/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library :  GEneric Tool for Finite Element Methods (getfem)             */
/* File    :  getfem_import.h : misc. imports.                             */
/*     									   */
/* Date : Januar 17, 2003.                                                 */
/* Authors : Julien Pommier, pommier@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2000-2002  Julien Pommier.                                */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU Lesser General Public License as          */
/* published by the Free Software Foundation; version 2.1 of the License.  */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU Lesser General Public License for more details.                     */
/*                                                                         */
/* You should have received a copy of the GNU Lesser General Public        */
/* License along with this program; if not, write to the Free Software     */
/* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/* USA.                                                                    */
/*                                                                         */
/* *********************************************************************** */

#ifndef GETFEM_IMPORT_H__
#define GETFEM_IMPORT_H__

#include <string>
#include <iostream>

namespace getfem {
  class getfem_mesh;

  /** 
      imports a mesh file.
      format can be:
      - "gid" for meshes generated by GiD http://gid.cimne.upc.es/
      - "gmsh" for meshes generated by GMSH http://www.geuz.org/gmsh/ 
      - "am_fmt" for 2D meshes from emc2 [http://pauillac.inria.fr/cdrom/prog/unix/emc2/eng.htm]
  */
  void import_mesh(const std::string& filename, const std::string& format, getfem_mesh& m);
  void import_mesh(std::ifstream& f, const std::string& format, getfem_mesh& m);
}
#endif /* GETFEM_IMPORT_H__  */
