% FUNCTION MF = gf_mesh_fem(...)
% 
%   General constructor for mesh_fem objects (Finite Element basis
%   functions on a mesh).
% 
%   * gf_mesh_fem(mesh M [, int Qdim=1])
% 
%   Return a getfem handle to the newly created mesh_fem object.
% 
%   * gf_mesh_fem('load', fname[, mesh M])
%   Load a meshfem from a file.   If the mesh M is not supplied (this kind of file
%   does not store the mesh), then it is read from the file and its descriptor is
%   returned as the second output argument.
% 
%   * gf_mesh_fem('from_string', str[, mesh M])
%   Create a mesh_fem object from its string description.  See also
%   gf_mesh_fem_get(MF,'char')
% 
%   * gf_mesh_fem('clone', meshfem MF2)
%   Create a copy of a mesh_fem.
% 
%   * gf_mesh_fem('sum', meshfem MF1, meshfem MF2 [, meshfem MF3, ..])
%   Create a mesh_fem that combines two (or more) mesh_fems  All mesh_fem must
%   share the same mesh (see gf_fem('interpolated_fem') to map a mesh_fem onto
%   another).  After that, you should not modify the FEM of MF1, MF2 etc.
% 
%   * gf_mesh_fem('levelset', meshfem MF, @tmls MLS)
%   Create a mesh_fem that is conformal to implicit surfaces defined by levelsets.
% 
%   * gf_mesh_fem('partial', meshfem MF, ivec DOFLST [,ivec RCVLST])
%   Build a restricted mesh_fem by keeping only a subset of the degrees of freedom
%   of MF.  If RCVLST is given, no FEM will be put on the convexes listed in
%   RCVLST.
% 
% 
%   $Id: gf_mesh_fem.cc 2722 2007-12-04 15:26:17Z renard $
function [varargout]=gf_mesh_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem',varargin{:});
  else
    gf_matlab('mesh_fem',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
