% FUNCTION M = gf_mdbrick_get(cmd, [, args])
%   Get information from a brick, or launch the solver.
% 
%   * gf_mdbrick_get(b,'nbdof')
%   Get the total number of dof of the current problem.  This is the sum of the
%   brick specific dof plus the dof of the parent bricks.
% 
%   * gf_mdbrick_get(b,'dim')
%   Get the dimension of the main mesh (2 for a 2D mesh, etc).
% 
%   * gf_mdbrick_get(b,'is_linear')
%   Return true if the problem is linear.
% 
%   * gf_mdbrick_get(b,'is_symmetric')
%   Return true if the problem is symmetric.
% 
%   * gf_mdbrick_get(b,'is_coercive')
%   Return true if the problem is coercive.
% 
%   * gf_mdbrick_get(b,'is_complex')
%   Return true if the problem uses complex numbers.
% 
%   * gf_mdbrick_get(b,'mixed_variables')
%   Identify the indices of mixed variables (typically the pressure, etc.) in the
%   tangent matrix.
% 
%   * gf_mdbrick_get(b,'subclass')
%   Get the typename of the brick.
% 
%   * gf_mdbrick_get(b,'param_list')
%   Get the list of parameters names.  Each brick embeds a number of parameters
%   (the Lam coefficients for the linearized elasticity brick, the wave number
%   for the Helmholtz brick,...), described as a (scalar, or vector, tensor etc)
%   field on a mesh_fem. You can read/change the parameter values with
%   gf_mdbrick_get(b,'param') and gf_mdbrick_set(b,'param').
% 
%   * gf_mdbrick_get(b,'param', string parameter_name)
%   Get the parameter value.  When the parameter has been assigned a specific
%   mesh_fem, it is returned  as a large array (the last dimension being the
%   mesh_fem dof). When no mesh_fem has been assigned, the parameter is considered
%   to be constant over the mesh.
% 
%   * gf_mdbrick_get(b,'solve', @mdstate mds [,...])
%   Run the standard getfem solver.  Note that you should be able to use your own
%   solver if you want (it is possible to obtain the tangent matrix and its right
%   hand side with the gf_mdstate_get(mds,'tangent_matrix') etc.).   Various
%   options can be specified:
%   
%     - 'noisy' or 'very noisy' : the solver will display some
%    information showing the progress (residual values etc.).
%    - 'max_iter', NIT         : set the maximum iterations numbers.
%    - 'max_res', RES          : set the target residual value.
%    - 'lsolver', SOLVERNAME   : select explicitely the solver used for< the
%   linear systems (the default value is 'auto', which lets getfem choose itself).
%   Possible values are 'superlu', 'mumps' (if supported), 'cg/ildlt', 'gmres/ilu'
%   and 'gmres/ilut'.
% 
%   * VM=gf_mdbrick_get(b,'von_mises', @mdstate mds, meshfem MFVM)
%   Compute the Von Mises stress on the mesh_fem MFVM.  Only available on bricks
%   where it has a meaning: linearized elasticity, plasticity, nonlinear
%   elasticity.. Note that in 2D it is not the "real" Von Mises (which should take
%   into account the 'plane stress' or 'plane strain' aspect), but a pure 2D Von
%   Mises.
% 
%   * VM=gf_mdbrick_get(b,'tresca', @mdstate mds, meshfem MFVM)
%   Compute the Tresca stress criterion on the mesh_fem MFVM.  Only available on
%   bricks where it has a meaning: linearized elasticity,  plasticity, nonlinear
%   elasticity..
% 
%   * gf_mdbrick_get(b,'memsize')
%   Return the amount of memory (in bytes) used by the model brick.
% 
% 
%   $Id: gf_mdbrick_get.cc 2531 2007-01-31 14:05:44Z renard $
function [varargout]=gf_mdbrick_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick_get',varargin{:});
  else
    gf_matlab('mdbrick_get',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
