% FUNCTION [x] = gf_mesh_fem_set(meshfem MF, operation [, args])
% 
%   General function for modifying mesh_fem objects.
%   
%   * gf_mesh_fem_set(MF,'fem,' @tfem FEM [, ivec CVIDX])
%   Set the Finite Element Method.  Assign a FEM to all convexes whose #ids are
%   listed in CVIDX. If CVIDX is not given, the integration is assigned to all
%   convexes.  See the help of gf_fem to obtain a list of available FEM methods.
% 
%   * gf_mesh_fem_set(MF,'classical_fem,' int K, [,ivec CVIDX])
%   Assign a classical (Lagrange polynomial) fem of order K to the meshfem.  Uses
%   FEM_PK for simplexes, FEM_QK for parallelepipeds etc.
% 
%   * gf_mesh_fem_set(MF,'classical_discontinuous_fem,' int K, [int IM_DEGREE [,ivec
%   CVIDX]])
%   Assigns a classical (Lagrange polynomial) discontinuous fem or order K.
%   Similar to gf_mesh_fem_set(MF,'classical_fem') except that
%   FEM_PK_DISCONTINUOUS is used.
% 
%   * gf_mesh_fem_set(MF,'qdim,' int Q)
%   Change the Q dimension of the field that is interpolated by the meshfem.  Q=1
%   means that the meshfem describes a scalar field, Q=N means that the meshfem
%   describes a vector field of dimension N.
% 
%   * gf_mesh_fem_set(MF,'dof_partition,' ivec DOFP)
%   Change the dof_partition array.  DOFP is a vector holding a integer value for
%   each convex of the mesh_fem. See gf_mesh_fem_get(MF,'dof_partition') for a
%   description of "dof partition".
% 
% 
%   $Id: gf_mesh_fem_set.cc 2537 2007-02-02 11:44:02Z pommier $
function [varargout]=gf_mesh_fem_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_fem_set',varargin{:});
  else
    gf_matlab('mesh_fem_set',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
