% Mesh slice creation.
% 
%   FUNCTION sl = gf_slice(sliceop, mesh M, int REFINE [, CVFLST])
%   FUNCTION sl = gf_slice(sliceop, mesh_fem MF, vec U, int REFINE [, CVFLST])
%   FUNCTION sl = gf_slice(sliceop, slice SL)
%   FUNCTION sl = gf_slice('streamlines', mesh_fem MF, vec U, mat SEEDS)
%   FUNCTION sl = gf_slice('points', mesh M, mat PTS)
% 
%   Creation of a mesh slice. Mesh slices are very similar to a
%   P1-discontinuous mesh_fem on which interpolation is very fast. The
%   slice is built from a mesh object, and a description of the slicing
%   operation, for example, 
%   
%   sl = gf_slice({'planar',+1,[0;0],[1;0]}, m, 5);
% 
%   cuts the original mesh with the half space {y>0}. Each convex of the
%   original mesh m is simplexified (for example a quadrangle is
%   splitted into 2 triangles), and each simplex is refined 5 times.
% 
%   Slicing operations can be:
%    - cutting with a plane, a sphere or a cylinder
%    - intersection or union of slices
%    - isovalues surfaces/volumes
%    - "points", "streamlines" (see below)
%   
%   If the first argument is a mesh_fem mf instead of a mesh, and if it
%   is followed by a field U (with size(U,1) == gf_mesh_fem_get(mf,U)),
%   then the deformation U will be applied to the mesh before the
%   slicing operation.
% 
%   The first argument can also be a slice.
% 
%   Slicing operations:
%   Always specifiy them between braces (i.e. in a cell array).  The
%   first argument is the name of the operation, followed the slicing
%   options.
% 
% 
%   * {'none'}
% 
%   Does not cut the mesh.
% 
%   * {'planar', orient, p, n} 
% 
%   Planar cut. p and n define a half-space, p being a point belong to
%   the boundary of the half-space, and n being its normal. If orient is
%   equal to -1 (resp. 0, +1), then the slicing operation will cut the
%   mesh with the "interior" (resp. "boundary", "exterior") of the
%   half-space. Orient may also be set to +2 which means that the mesh
%   will be sliced, but both the outer and inner parts will be kept.
% 
%   * {'ball', orient, c, r}
%   
%   Cut with a ball of center c and radius r.
% 
%   * {'cylinder', orient, p1, p2, r}
% 
%   Cut with a cylinder whose axis is the line (p1,p2) and whose radius
%   is r.
% 
%   * {'isovalues',orient, mesh_fem MF, vec U, scalar V}
% 
%   Cut using the isosurface of the field U (defined on the mesh_fem
%   MF). The result is the set {x such that U(x) <= V} or {x such that
%   U(x) == V} or {x such that U(x) <= V} depending on the value of
%   ORIENT.
% 
%   * {'boundary'[, SLICEOP]}
%   
%   Return the boundary of the result of SLICEOP, where SLICEOP is any
%   slicing operation. If SLICEOP is not specified, then the whole mesh
%   is considered (i.e. it is equivalent to {'boundary',{'none'}}).
% 
%   * {'explode', coef}
% 
%   Build an 'exploded' view of the mesh: each convex is shrinked (0 <
%   coef <= 1). In the case of 3D convexes, only their faces are kept. 
% 
%   * {'union', SLICEOP1, SLICEOP2}
%   * {'intersection', SLICEOP1, SLICEOP2}
%   * {'comp', SLICEOP}
%   * {'diff', SLICEOP1, SLICEOP2}
% 
%   Boolean operations: returns the union,intersection,complementary or
%   difference of slicing operations.
% 
%   * {'mesh', MESH}
% 
%   Build a slice which is the intersection of the sliced mesh with
%   another mesh. The slice is such that all of its simplexes are
%   stricly contained into a convex of each mesh.
% 
%   EXAMPLE:
%   
%   sl = gf_slice({intersection',{'planar',+1,[0;0;0],[0;0;1]},...
%                 {'isovalues',-1,mf2,U2,0}},mf,U,5);
% 
%   view the convex quality of a 2D or 3D mesh m:
% 
%   gf_plot_slice(gfSlice({'explode', 0.7}, m, 2), 'convex_data',...
%                 gf_mesh_get(m,'quality'));
% 
% 
%   SPECIAL SLICES:
% 
%   There are also some special calls to gf_slice:
% 
%   * gf_slice('streamlines',mf, U, mat SEEDS)
% 
%   compute streamlines of the (vector) field U, with seed points given
%   by the columns of SEEDS.
% 
%   * gf_slice('points', m, mat PTS)
% 
%   return the "slice" composed of points given by the columns of PTS
%   (useful for interpolation on a given set of sparse points, see
%   gf_compute(mf,U,'interpolate on',sl).
% 
%   * gf_slice('load', filename [,m])
% 
%   load the slice (and its linked_mesh if it is not given as an
%   argument) from a text file.
% 
%   $Id: gf_slice.cc 2544 2007-02-06 20:41:07Z renard $
function [varargout]=gf_slice(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('slice',varargin{:});
  else
    gf_matlab('slice',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
