% FUNCTION M = gf_mdbrick(brick_name, [, args])
%   General constructor for mdbrick object. Returns a getfem handle to the newly
%   created object.
% 
%   Many of the bricks take a "numfem" optional parameter, which
%   is the meshfem number in the stack of parent bricks (by default
%   numfem=0, i.e. it refers to the first meshfem in the stack of
%   bricks).
%   
%   * B=gf_mdbrick('constraint', mdbrick parent, string CTYPE [, int numfem])
%   Build a generic constraint brick.   It may be useful in some situations, such
%   as the Stokes problem where the pressure in defined modulo a constant. In such
%   a situation, this brick can be used to add an additional constraint on the
%   pressure value.       CTYPE has to be chosen among 'augmented', 'penalized',
%   and 'eliminated'.  The constraint can be specified with
%   gf_mdbrick_set(b,'constraints'). Note that Dirichlet bricks (except the
%   'generalized Dirichlet' one) are also specializations of the 'constraint'
%   brick.
% 
%   * B=gf_mdbrick('dirichlet', mdbrick parent, int BNUM, meshfem MFMULT, string
%   CTYPE [, int numfem])
%   Build a Dirichlet condition brick which impose the value of a field along a
%   mesh boundary.  The BNUM parameter selects on which mesh region the Dirichlet
%   condition is imposed. CTYPE has to be chosen among 'augmented', 'penalized',
%   and 'eliminated'. The MFMULT may generally be taken as the meshfem of the
%   unknown, but for 'augmented' Dirichlet conditions, you may have to respect the
%   Inf-Sup condition and choose an adequate meshfem.
% 
%   * B=gf_mdbrick('dirichlet_on_normal_component', mdbrick parent, int BNUM,
%   meshfem MFMULT, string CTYPE [, int numfem])
%   Build a Dirichlet condition brick which imposes the value of the normal
%   component of a vector field.
% 
%   * B=gf_mdbrick('dirichlet_on_normal_derivative', mdbrick parent, int BNUM,
%   meshfem MFMULT, string CTYPE [, int numfem])
%   Build a Dirichlet condition brick which imposes the value of the normal
%   derivative of the unknown.
% 
%   * B=gf_mdbrick('generalized_dirichlet', mdbrick parent, int BNUM [, int numfem])
%   This is the "old" Dirichlet brick of getfem.  This brick can be used to impose
%   general Dirichlet conditions 'h(x)u(x) = r(x)' , however it may have some
%   issues with elaborated FEM (such as Argyris, etc). It should be avoided when
%   possible.
% 
%   * B=gf_mdbrick('source_term', mdbrick parent, [, int BNUM=-1[, int numfem]])
%   Add a boundary or volumic source term ( \int B.v ).  If BNUM is omitted (or
%   set to -1) , the brick adds a volumic source term on the whole mesh. For BNUM
%   >= 0, the source term is imposed on the mesh region BNUM. Use
%   gf_mdbrick_set(b,'param','source term',mf,B) to set the source term field. The
%   source term is expected as a vector field of size Q (with Q = qdim).
% 
%   * B=gf_mdbrick('normal_source_term', mdbrick parent, int BNUM [, int numfem])
%   Add a boundary source term ( \int (Bn).v ).  The source term is imposed on the
%   mesh region BNUM (which of course is not allowed to be a volumic region, only
%   boundary regions are allowed). Use gf_mdbrick_set(b,'param','source
%   term',mf,B) to set the source term field. The source term B is expected as
%   tensor field of size QxN (with Q = qdim, N = mesh dim). For example, if you
%   consider an elasticity problem, this brick may be used to impose a force on
%   the boundary with B as the stress tensor.
% 
%   * B=gf_mdbrick('normal_derivative_source_term', mdbrick parent, int BNUM [, int
%   numfem])
%   Add a boundary source term ( \int (\partial_n B).v ).  The source term is
%   imposed on the mesh region BNUM. Use gf_mdbrick_set(b,'param','source
%   term',mf,B) to set the source term field, which is expected as a vector field
%   of size Q (with Q = qdim).
% 
%   * B=gf_mdbrick('neumann KirchhoffLove source term', mdbrick parent, int BNUM [,
%   int numfem])
%    Add a boundary source term for neumann Kirchhoff-Love plate problems (should
%   be used with the Kirchhoff-Love flavour of the bilaplacian brick).
% 
%   * B=gf_mdbrick('qu_term', mdbrick parent, [, int BNUM [, int numfem]])
%   Update the tangent matrix with a \int (Qu).v term.  The Q(x) parameter is a
%   matrix field of size qdim x qdim. An example of use is for the "iku" part of
%   Robin boundary conditions \partial_n u + iku = ...
% 
%   * B=gf_mdbrick('mass_matrix', meshim mim, meshfem mf_u [,'real'|'complex'])
%   Build a mass-matrix brick.
% 
%   * B=gf_mdbrick('generic_elliptic', meshim MIM, meshfem mfu
%   [,'scalar'|'matrix'|'tensor'][,'real'|'complex'])
%   Setup a generic elliptic problem ( (A*grad(U)).grad(V) ).  The brick parameter
%   'A' may be a scalar field, a matrix field, or a tensor field (default is
%   scalar).
% 
%   * B=gf_mdbrick('helmholtz', meshim MIM, meshfem mfu [,'real'|'complex'])
%   Setup a Helmholtz problem.  The brick has one parameter, 'wave_number'.
% 
%   * B=gf_mdbrick('isotropic_linearized_elasticity', meshim MIM, meshfem mfu)
%   Setup a linear elasticity problem.  The brick has two scalar parameter,
%   'lambda' and 'mu' (the Lame coefficients).
% 
%   * B=gf_mdbrick('linear_incompressibility_term', mdbrick parent, meshfem mf_p [,
%   int numfem])
%   Add an incompressibily constraint (div u = 0).
% 
%   * B=gf_mdbrick('nonlinear_elasticity', meshim MIM, meshfem mfu, string lawname)
%   Setup a nonlinear elasticity (large deformations) problem.  The material law
%   can be chosen among - 'SaintVenant Kirchhoff' (linearized material law) -
%   'Mooney Rivlin' (to be used with the nonlinear incompressibily term) -
%   'Ciarlet Geymonat'
% 
%   * B=gf_mdbrick('nonlinear_elasticity_incompressibility_term', mdbrick parent,
%   meshfem mf_p [, int numfem])
%   Add an incompressibily constraint to a large strain elasticity problem.
% 
%   * B=gf_mdbrick('small_deformations_plasticity', meshim MIM, meshfem mfu, scalar
%   THRESHOLD)
%   Setup a plasticity problem (with small deformations).  The THRESHOLD parameter
%   is the maximum value of the Von Mises stress before 'plastification' of the
%   material.
% 
%   * B=gf_mdbrick('dynamic', mdbrick parent, scalar rho [, int numfem])
%   Dynamic brick. This brick is not ready.
% 
%   * B=gf_mdbrick('navier_stokes', meshim MIM, meshfem mfu, meshfem mfp)
%   Setup a Navier-Stokes problem (this brick is not ready, do not use it).
% 
%   * B=gf_mdbrick('bilaplacian', meshim MIM, meshfem mfu, ['Kirchhoff-Love'])
%   Setup a bilaplacian problem.  If the Kirchhoff-Love option is specified, the
%   Kirchhoff-Love plate model is used.
% 
%   * B=gf_mdbrick('isotropic_linearized_plate', meshim MIM, meshim MIMSUB, meshfem
%   MF_UT, meshfem MF_U3, meshfem MF_THETA, scalar EPSILON)
%    Setup a linear plate model brick (for moderately thick plates, using the
%   Reissner-Mindlin model). EPSILON is the plate thinkness, the @mf MF_UT and
%   MF_U3 are used respectively for the membrane displacement and the transverse
%   displacement of the plate. The @mf MF_THETA is the rotation of the normal
%   ("section rotations").  The second integration method MIMSUB can be chosen
%   equal to MIM, or different if you want to perform sub-integration on the
%   transverse shear term (mitc4 projection).  This brick has two parameters
%   "lambda" and "mu" (the Lam coefficients)
% 
%   * B=gf_mdbrick('mixed_isotropic_linearized_plate', meshim MIM, meshfem MF_UT,
%   meshfem MF_U3, meshfem MF_THETA, scalar EPSILON)
%    Setup a mixed linear plate model brick (for thin plates, using Kirchhoff-Love
%   model).  For a non-mixed version, use the bilaplacian brick.
% 
%   * B=gf_mdbrick('plate_source_term', mdbrick parent, [, int BNUM=-1[, int
%   numfem]])
%    Add a boundary or a volumic source term to a plate problem. This brick has
%   two parameters: "B" is the displacement (ut and u3) source term, "M" is the
%   moment source term (i.e. the source term on the rotation of the normal).
% 
%   * B=gf_mdbrick('plate_simple_support', mdbrick parent, int BNUM, string CTYPE [,
%   int numfem])
%    Add a "simple support" boundary condition to a plate problem (homogeneous
%   Dirichlet condition on the displacement, free rotation). CTYPE specifies how
%   the constraint is enforced ('penalized', 'augmented' or 'eliminated').
% 
%   * B=gf_mdbrick('plate_clamped_support', mdbrick parent, int BNUM, string CTYPE
%   [, int numfem])
%    Add a "clamped support" boundary condition to a plate problem (homogeneous
%   Dirichlet condition on the displacement and on the rotation). CTYPE specifies
%   how the constraint is enforced ('penalized', 'augmented' or 'eliminated').
% 
%   * B=gf_mdbrick('plate_closing', mdbrick parent [, int numfem])
%    Add a free edges condition for the mixed plate model brick.  This brick is
%   required when the mixed linearized plate brick is used. It must be inserted
%   after all other boundary conditions (the reason is that the brick has to
%   inspect all other boundary conditions to determine the number of disconnected
%   boundary parts which are free edges).
% 
%   $Id: gf_mdbrick.cc 2722 2007-12-04 15:26:17Z renard $
function [varargout]=gf_mdbrick(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick',varargin{:});
  else
    gf_matlab('mdbrick',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
