% FUNCTION ELTM = gf_eltm(elt_matrix_type, args..)
% Eltm = gf_eltm(...)
% 
%   * gf_eltm('base', Fem FEM)
%     return a descriptor for the integration of shape functions on
%     elements, using the Fem `FEM`.
%  * gf_eltm('grad', Fem FEM)
%     return a descriptor for the integration of the gradient of shape
%     functions on elements, using the Fem `FEM`.
%  * gf_eltm('hessian', Fem FEM)
%     return a descriptor for the integration of the hessian of shape
%     functions on elements, using the Fem `FEM`.
%  * gf_eltm('normal')
%     return a descriptor for the unit normal of convex faces.
%  * gf_eltm('grad_geotrans')
%     return a descriptor to the gradient matrix of the geometric
%     transformation.
%  * gf_eltm('grad_geotrans_inv')
%     return a descriptor to the inverse of the gradient matrix of the
%     geometric transformation (this is rarely used).
%  * gf_eltm('product', Eltm A, Eltm B)
%     return a descriptor for the integration of the tensorial product
%     of elementary matrices `A` and `B`.
% 
%   In order to obtain a numerical value of theses matrices, see
% gf_mesh_im_get(MIM,'eltm').
function [varargout]=gf_eltm(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('eltm',varargin{:});
  else
    gf_matlab('eltm',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
