% FUNCTION F=gf_fem(string FEM_NAME)
%     Returns a handle F to one of the various Finite Elements Method defined
%     in Getfem.
% 
%     example of FEM names are:
% Fem = gf_fem(string fem_name)
% 
%   The `fem_name` should contain a description of the finite element method.
%  Please refer to the getfem++ manual (especially the description of finite
%  element and integration methods) for a complete reference. Here is a list
%  of some of them:
% 
%   * FEM_PK(n,k)
%     classical Lagrange element Pk on a simplex of dimension `n`.
%  * FEM_PK_DISCONTINUOUS(N,K[,alpha])
%     discontinuous Lagrange element Pk on a simplex of dimension `n`.
%  * FEM_QK(n,k)
%     classical Lagrange element Qk on quadrangles, hexahedrons etc.
%  * FEM_QK_DISCONTINUOUS(n,k[,alpha])
%     discontinuous Lagrange element Qk on quadrangles, hexahedrons etc.
%  * FEM_Q2_INCOMPLETE
%     incomplete 2D Q2 element with 8 dof (serendipity Quad 8 element).
%  * FEM_PK_PRISM(n,k)
%     classical Lagrange element Pk on a prism.
%  * FEM_PK_PRISM_DISCONTINUOUS(n,k[,alpha])
%     classical discontinuous Lagrange element Pk on a prism.
%  * FEM_PK_WITH_CUBIC_BUBBLE(n,k)
%     classical Lagrange element Pk on a simplex with an additional volumic
%     bubble function.
%  * FEM_P1_NONCONFORMING
%     non-conforming P1 method on a triangle.
%  * FEM_P1_BUBBLE_FACE(n)
%     P1 method on a simplex with an additional bubble function on face 0.
%  * FEM_P1_BUBBLE_FACE_LAG
%     P1 method on a simplex with an additional lagrange dof on face 0.
%  * FEM_PK_HIERARCHICAL(n,k)
%     PK element with a hierarchical basis.
%  * FEM_QK_HIERARCHICAL(n,k)
%     QK element with a hierarchical basis
%  * FEM_PK_PRISM_HIERARCHICAL(n,k)
%     PK element on a prism with a hierarchical basis.
%  * FEM_STRUCTURED_COMPOSITE(FEM,k)
%     Composite fem on a grid with `k` divisions.
%  * FEM_PK_HIERARCHICAL_COMPOSITE(n,k,s)
%     Pk composite element on a grid with `s` subdivisions and with a
%     hierarchical basis.
%  * FEM_PK_FULL_HIERARCHICAL_COMPOSITE(n,k,s)
%     Pk composite element with `s` subdivisions and a hierarchical basis
%     on both degree and subdivision.
%  * FEM_PRODUCT(FEM1,FEM2)
%     tensorial product of two polynomial elements.
%  * FEM_HERMITE(n)
%     Hermite element P3 on a simplex of dimension `n = 1, 2, 3`.
%  * FEM_ARGYRIS
%     Argyris element P5 on the triangle.
%  * FEM_HCT_TRIANGLE
%     Hsieh-Clough-Tocher element on the triangle (composite P3
%     element which is C^1), should be used with IM_HCT_COMPOSITE()
%     integration method.
%  * FEM_QUADC1_COMPOSITE
%     Quadrilateral element, composite P3 element and C^1 (16 dof).
%  * FEM_REDUCED_QUADC1_COMPOSITE
%     Quadrilateral element, composite P3 element and C^1 (12 dof).
%  * FEM_RT0(n)
%     Raviart-Thomas element of order 0 on a simplex of dimension `n`.
%  * FEM_NEDELEC(n)
%     Nedelec edge element of order 0 on a simplex of dimension `n`.
% 
%   Of course, you have to ensure that the selected fem is compatible with
%  the geometric transformation: a Pk fem has no meaning on a quadrangle.
% 
% 
%   * Fem = gf_fem('interpolated_fem', MeshFem mf, MeshIm mim, [ivec blocked_dof])
%   Build a special Fem which is interpolated from another MeshFem.
%   
%     Using this special finite element, it is possible to interpolate a given
%   MeshFem `mf` on another mesh, given the integration method `mim` that will be
%   used on this mesh.
%   
%     Note that this finite element may be quite slow, and eats much memory.
% 
function [varargout]=gf_fem(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('fem',varargin{:});
  else
    gf_matlab('fem',varargin{:});
    if (exist('ans','var') == 1), varargout{1}=ans; end;
  end;
