/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library : Getfem Interface (getfemint)                                  */
/* File    : getfemint_mesh.h : mesh management.                           */
/*     									   */
/*                                                                         */
/* Date : August 2002                                                      */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr,J. Pommier           */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef GETFEMINT_MESH_H__
#define GETFEMINT_MESH_H__

#include <getfemint_std.h>
#include <getfemint_object.h>
#include <getfem_mesh.h>

namespace getfemint
{
  class getfemint_mesh : public getfem_object {
  private:
    getfem::getfem_mesh *m;

  public:
    getfemint_mesh() { 
      assert(workspace == 0);
      m = new getfem::getfem_mesh();
    }
    ~getfemint_mesh() {
      m->clear();
      delete m;
    }
    id_type class_id() const { return MESH_CLASS_ID; }
    size_type memsize() const { return m->memsize(); }
    getfem::getfem_mesh& mesh() { return *m; }
    const getfem::getfem_mesh& mesh() const { return *m; }
  };

  inline bool object_is_mesh(getfem_object *o) {
    return (o->class_id() == MESH_CLASS_ID);
  }

  inline getfemint_mesh* object_to_mesh(getfem_object *o) {
    if (object_is_mesh(o)) return ((getfemint_mesh*)o);
    else THROW_INTERNAL_ERROR;
  }
}  /* end of namespace getfemint.                                          */

#endif /* GETFEMINT_MESH_H__                                               */
