/* -*- c++ -*- (enables emacs c++ mode)                                    */
/* *********************************************************************** */
/*                                                                         */
/* Library : Getfem Interface (getfemint)                                  */
/* File    : getfemint_mesh_fem.C : mesh fem management.                   */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#ifndef GETFEMINT_MESH_FEM_H__
#define GETFEMINT_MESH_FEM_H__

#include <getfemint.h>
#include <getfemint_object.h>
#include <getfemint_mesh.h>
#include <getfem_mesh_fem.h>

namespace getfemint
{

  class getfemint_mesh_fem : public getfemint::getfem_object {
  private:
    getfem::mesh_fem *mf;
    id_type linked_mesh_id_;
  public:
    getfemint_mesh_fem(getfemint_mesh *m, unsigned q_dim) { 
      assert(workspace == 0);
      linked_mesh_id_ = m->get_id();
      mf = new getfem::mesh_fem(m->mesh());
      mf->set_qdim(q_dim);
    }
    ~getfemint_mesh_fem() {
      delete mf;
    }
    id_type class_id() const { return MESHFEM_CLASS_ID; }
    size_type memsize() const { return mf->memsize(); }
    
    void clear() { mf->clear(); }

    getfem::mesh_fem& mesh_fem() { return *mf; }
    const getfem::mesh_fem& mesh_fem() const { return *mf; }
    const getfem::getfem_mesh& linked_mesh() const { return mf->linked_mesh(); }
    id_type linked_mesh_id() const { return linked_mesh_id_;}
  };

  inline bool object_is_mesh_fem(getfem_object *o) {
    return (o->class_id() == MESHFEM_CLASS_ID);
  }

  inline getfemint_mesh_fem* object_to_mesh_fem(getfem_object *o) {
    if (object_is_mesh_fem(o)) return ((getfemint_mesh_fem*)o);
    else THROW_INTERNAL_ERROR;
  }
}  /* end of namespace getfemint.                                          */

#endif /* GETFEMINT_MESH_FEM_H__                                           */
