/* *********************************************************************** */
/*                                                                         */
/* Library : Getfem Interface (getfemint)                                  */
/* File    : getfemint_pfem.C : finite element methods management.         */
/*     									   */
/*                                                                         */
/* Date : October 11, 2001.                                                */
/* Author : Yves Renard, Yves.Renard@gmm.insa-tlse.fr                      */
/*                                                                         */
/* *********************************************************************** */
/*                                                                         */
/* Copyright (C) 2001  Yves Renard.                                        */
/*                                                                         */
/* This file is a part of GETFEM++                                         */
/*                                                                         */
/* This program is free software; you can redistribute it and/or modify    */
/* it under the terms of the GNU General Public License as published by    */
/* the Free Software Foundation; version 2 of the License.                 */
/*                                                                         */
/* This program is distributed in the hope that it will be useful,         */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/* GNU General Public License for more details.                            */
/*                                                                         */
/* You should have received a copy of the GNU General Public License       */
/* along with this program; if not, write to the Free Software Foundation, */
/* Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.         */
/*                                                                         */
/* *********************************************************************** */


#include <getfemint_pfem.h>
#include <dal_tree_sorted.h>

namespace getfemint
{
  static dal::dynamic_tree_sorted<getfem::pfem> *pfem_tab;

  static inline void init_tab(void) // because of problem with initialization
  {                                 // in dynamic libraries.
    static bool initialized = false;
    if (!initialized)
    { 
      initialized = true;
      pfem_tab = new dal::dynamic_tree_sorted<getfem::pfem>();
    }
  }

  id_type ind_pfem(getfem::pfem p)
  { init_tab(); return pfem_tab->add_norepeat(p); }
  
  getfem::pfem addr_pfem(id_type i)
  { init_tab(); return (*pfem_tab)[i]; }

  bool exists_pfem(id_type i)
  { init_tab(); return pfem_tab->index()[i]; }


}  /* end of namespace getfemint.                                          */
