#include <getfemint_misc.h>
#include <getfemint_matelemtype.h>
#include <getfemint_pfem.h>

using namespace getfemint;

/*MLABCOM

  FUNCTION ELTM = gf_eltm(elt_matrix_type, args..)
  @TEXT ELTM:INIT('ELTM_init')
MLABCOM*/

/*@TEXT ELTM:INIT('ELTM_init')
  Generates a descriptor for an elementary matrix type.<Par>

  * ELTM:INIT('base', @tfem FEM)<par>
  Integration of shape functions on elements, using the fem FEM.<Par>

  * ELTM:INIT('grad', @tfem FEM)<par>
  Integration of gradient of shape functions on elements, using the fem FEM.<Par>

  * ELTM:INIT('hessian', @tfem FEM)<par>
  Integration of hessian of shape functions on elements, using the fem FEM.<Par>

  * ELTM:INIT('product', @eltm A, @eltm B)<par>
  Integration of the tensorial product of elementary matrices A and B.<Par>
  
  In order to obtain a numerical value of theses matrices, see MESHFEM:GET('eltm').
@*/


void gf_eltm(getfemint::mexargs_in& in, getfemint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd                  = in.pop().to_string();
  
  if (check_cmd(cmd, "base", in, out, 1, 1, 0, 1)) {  
    getfem::pfem pf                  = in.pop().to_fem();
    out.pop().from_object_id(getfemint::ind_matelemtype(getfem::mat_elem_base(pf)), 
			     ELTM_CLASS_ID);
  } else if (check_cmd(cmd, "grad", in, out, 1, 1, 0, 1)) {  
    getfem::pfem pf                  = in.pop().to_fem();
    out.pop().from_object_id(getfemint::ind_matelemtype(getfem::mat_elem_grad(pf)),
			     ELTM_CLASS_ID);
  } else if (check_cmd(cmd, "hessian", in, out, 1, 1, 0, 1)) {  
    getfem::pfem pf                  = in.pop().to_fem();
    out.pop().from_object_id(getfemint::ind_matelemtype(getfem::mat_elem_hessian(pf)),
			     ELTM_CLASS_ID);
  } else if (check_cmd(cmd, "product", in, out, 2, 2, 0, 1)) {  
    getfem::pmat_elem_type  m1 = in.pop().to_mat_elem_type();
    getfem::pmat_elem_type  m2 = in.pop().to_mat_elem_type();
    out.pop().from_object_id(getfemint::ind_matelemtype(getfem::mat_elem_product(m1,m2)),
			     ELTM_CLASS_ID);
  } else bad_cmd(cmd);
}

