#include <getfemint_misc.h>
#include <getfemint_pfem.h>

using namespace getfemint;
/*MLABCOM
  FUNCTION F=gf_fem(string FEM_NAME)
    Returns a handle F to one of the various Finite Elements Method defined
    in Getfem.

    example of FEM names are:
    @TEXT FEM:INIT('FEM_list')

MLABCOM*/

/*@TEXT FEM:INIT('FEM_list')
    * FEM_PK(N,K)<par>
      classical Lagrange element PK on a simplex of dimension N<par>
    * FEM_PK_DISCONTINUOUS(N,K)} <par>
       discontinuous Lagrange element PK on a simplex of dim N<par>
    * FEM_QK(N,K)}      <par>
      classical Lagrange element QK on quadrangles, hexahedrons etc<par>
    * FEM_PK_PRISM(N,K) <par>
      classical Lagrange element PK on a prism<par>
    * FEM_PK_WITH_CUBIC_BUBBLE(N,K)   <par>
      classical Lagrange element PK on a simplex with an additional volumic bubble function.<par>
    * FEM_PRODUCT(FEM1,FEM2)<par>
      tensorial product of two polynomial elements<par>
    * FEM_P1_NONCONFORMING <par>
      non-conforming P1 method on a triangle.<par>
    * FEM_P1_BUBBLE_FACE(N)   <par>
      P1 method on a simplex with an additional bubble function on face 0.<par>
    * FEM_P1_BUBBLE_FACE_LAG  <par>
      P1 method on a simplex with an additional lagrange dof on face 0.<par>
    * FEM_HERMITE_SEGMENT       <par>
      Hermite element on the segment<par>
    * FEM_PK_HIERARCHICAL(N,K)  <par>
      PK element with a hierarchical basis<par>
    * FEM_QK_HIERARCHICAL(N,K)  <par>
      QK element with a hierarchical basis<par>
    * FEM_PK_PRISM_HIERARCHICAL(N,K)   <par>
      PK element on a prism with a hierarchical basis<par>
    * FEM_STRUCTURED_COMPOSITE(FEM, K) <par>
      Composite fem on a grid with K divisions<par>
    * FEM_PK_HIERARCHICAL_COMPOSITE(N,K,S)<par>
      PK composite element on a grid with S subdivisions and with a hierarchical basis<par>
    * FEM_PK_FULL_HIERARCHICAL_COMPOSITE(N,K,S) <par>
      PK composite element with S subdivisions and a hierarchical basis on both degree and subdivision<par>
      @*/

void gf_fem(getfemint::mexargs_in& in, getfemint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(getfemint::ind_pfem(getfem::fem_descriptor(cmd)), FEM_CLASS_ID);
}
