#include <getfemint.h>
#include <getfemint_pgt.h>

using namespace getfemint;

/*MLABCOM
  FUNCTION I = gf_geotrans(name)
    @TEXT GEOTRANS:INIT('GEOTRANS_init')
MLABCOM*/

/*@TEXT GEOTRANS:INIT('GEOTRANS_init')
    General function for building descriptors to geometric transformations.

    Name can be: 
    * 'GT_PK(N,K)'   : Transformation on simplexes, dim N, degree K
    * 'GT_QK(N,K)'   : Transformation on parallelepipeds, dim N, degree K
    * 'GT_PRISM(N,K)'          : Transformation on prisms, dim N, degree K
    * 'GT_PRODUCT(a,b)'        : tensorial product of two transformations
    * 'GT_LINEAR_PRODUCT(a,b)' : Linear tensorial product of two transformations
    @*/

void gf_geotrans(getfemint::mexargs_in& in, getfemint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(getfemint::ind_pgt(bgeot::geometric_trans_descriptor(cmd)),
			   GEOTRANS_CLASS_ID);
}
