#include <getfemint.h>
#include <getfemint_integ.h>

using namespace getfemint;

/*MLABCOM
  @TEXT INTEG:INIT('INTEG_init')
MLABCOM*/

/*@TEXT INTEG:INIT('INTEG_init')
    INTEG:INIT(@string method)
    Return a FEM Integration Method from a string description.<Par>

    Possible descriptions are (may not be exhaustive):<par>
    * IM_EXACT_SIMPLEX(n)<par>
      Exact integration on simplexes (works only with linear geometric
      transformations and PK FEMs).<par>
    * IM_PRODUCT(a, b)
      Product of two integration methods.<Par>

    * IM_EXACT_PARALLELEPIPED(n)<par>
      Exact integration on parallelepipeds.<Par>

    * IM_EXACT_PRISM(n)      <par>
      Exact integration on prisms.<Par>

    * IM_GAUSS1D(K)       <par>
      Gauss method on the segment, order K (K=1,3,...99).<Par>

    * IM_NC(N,K)          <par>
      Newton-Cotes approximative integration on simplexes, order K.<Par>

    * IM_NC_PARALLELEPIPED(N,K) <par>
      Product of Newton-Cotes integration on parallelepipeds.<Par>

    * IM_NC_PRISM(N,K) <par>
      Product of Newton-Cotes integration on prisms.<Par>

    * IM_GAUSS_PARALLELEPIPED(N,K) <par>
      Product of Gauss1D integration on parallelepipeds.<Par>

    * IM_TRIANGLE(K)<par>
      Gauss methods on triangles (K=1,3,5,..13,19).<Par>

    * IM_QUAD(K)<par>
      Gauss methods on quadrilaterons (K=2, 3, 5, .. 17). Note that IM_GAUSS_PARALLELEPIPED should be prefered for QK FEMs.<Par>

    * IM_TETRAHEDRON(K)<par>
      Gauss methods on tetrahedrons (K=1, 2, 3 or 5).<Par>


    example:<par>
      INTEG:INIT('IM_PRODUCT(IM_GAUSS1D(5),IM_GAUSS1D(5))')<par>
      is the same as:<par>
      INTEG:INIT('IM_GAUSS_PARALLELEPIPED(2,5)')<par>
      @*/

void gf_integ(getfemint::mexargs_in& in, getfemint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG( "Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();
  out.pop().from_object_id(getfemint::ind_integ(getfem::int_method_descriptor(cmd)),
			   INTEG_CLASS_ID);
}

