#include <getfemint.h>
#include <getfemint_misc.h>
#include <gmm_inoutput.h>
#include <getfemint_gsparse.h>
#include <getfemint_gsparse_misc.h>

using namespace getfemint;

/*MLABCOM
  FUNCTION gf_util(operation, poly [,args])

  Performs various operations

  * gf_util('save matrix', string FMT, string FILENAME, spmat A);

  Exports a sparse matrix into the file named FILENAME, using
  Harwell-Boeing (FMT='hb') or Matrix-Market (FMT='mm') formatting.

  * A = gf_util('load matrix', string FMT, string FILENAME);

  Imports a sparse matrix from a file.

MLABCOM*/

void gf_util(getfemint::mexargs_in& in, getfemint::mexargs_out& out)
{
  if (in.narg() < 1) {
    THROW_BADARG("Wrong number of input arguments");
  }
  std::string cmd = in.pop().to_string();

  if (check_cmd(cmd, "save matrix", in, out, 3, 3, 0, 0)) {
    std::string fmt = in.pop().to_string();
    int ifmt;
    if (cmd_strmatch(fmt, "hb") || cmd_strmatch(fmt, "harwell-boeing")) ifmt = 0;
    else if (cmd_strmatch(fmt, "mm") || cmd_strmatch(fmt, "matrix-market")) ifmt = 1;
    else THROW_BADARG("unknown sparse matrix file-format : " << fmt);
    std::string fname = in.pop().to_string();
    if (!in.front().is_complex()) {
      gf_real_sparse_csc_const_ref H;  in.pop().to_sparse(H);
      gmm::csc_matrix<double> cscH; gmm::copy(H,cscH);
      if (ifmt == 0) gmm::Harwell_Boeing_save(fname.c_str(), cscH);
      else           gmm::MatrixMarket_save(fname.c_str(), cscH);
    } else {
      gf_cplx_sparse_csc_const_ref H;  in.pop().to_sparse(H);
      gmm::csc_matrix<complex_type> cscH; gmm::copy(H,cscH);
      if (ifmt == 0) gmm::Harwell_Boeing_save(fname.c_str(), cscH);
      else           gmm::MatrixMarket_save(fname.c_str(), cscH);      
    }
  } else if (check_cmd(cmd, "load matrix", in, out, 2, 2, 1, 1)) {
    spmat_load(in, out, mexarg_out::USE_NATIVE_SPARSE);
  } else bad_cmd(cmd);
}

