function [varargout] = subsref(fem,index)
% gfFem/SUBSREF Define field name indexing for gfFem objects
%  accessible methods:
%    fem.id  
%    fem.nbdof
%    fem.dim
%    fem.target_dim
%    fem.is_polynomial
%    ...etc

  nout = max(nargout,1);  
  switch index(1).type
   case '()'
    error('indexes not supported');
   case '.'
    if (strcmp(index(1).subs,'id'))
      varargout{1} = fem.id;
    else
      varargout{1} = gf_fem_get(fem,index(1).subs);
    end;
   case '{}'
    error('cell access not supported');
  end
  if (numel(index) > 1)
    for i=1:nargout,
      varargout{i} = subsref(varargout{i},index(2:end));
    end;
  end;  
