function [varargout] = subsref(gt,index)
% gfGeoTrans/SUBSREF Define field name indexing for gfGeoTrans objects
%  accessible methods:
%    gt.id  
%    gt.nbpts
%    gt.dim
%    gt.target_dim
%    gt.is_linear
%    gt.pts
%    gt.normals
  nout = max(nargout,1);  
  switch index(1).type
   case '()'
    error('indexes not supported');
   case '.'
    if (strcmp(index(1).subs,'id'))
      varargout{1} = gt.id;
    else
      varargout{1} = gf_geotrans_get(gt,index(1).subs);
    end;
   case '{}'
    error('cell access not supported');
  end
  if (numel(index) > 1)
    for i=1:nargout,
      varargout{i} = subsref(varargout{i},index(2:end));
    end;
  end;  
