trace on;
clear pde; gf_workspace('clear all');
m = gf_mesh('cartesian',[0:.1:1],[0:.1:1]);
gf_plot_mesh(m, 'vertices', 'on', 'convexes', 'on');
pause(1);
% create a mesh_fem of for a field of dimension 1 (i.e. a scalar field)
mf = gf_mesh_fem(m,1);
% assign the Q2 fem to all convexes of the mesh_fem,
% with an exact integration method
gf_mesh_fem_set(mf,'fem',gf_fem('FEM_QK(2,2)'), gf_integ('IM_EXACT_PARALLELEPIPED(2)'));
% detect the border of the mesh
border = gf_mesh_get(m,'outer faces');
% mark it as boundary #1
gf_mesh_fem_set(mf, 'boundary', 1, border);
gf_plot_mesh(mf, 'boundaries', [1]); % the boundary edges appears in red
pause(1);

% setup a pde structure for gf_solve
pde.type = 'laplacian';
pde.lambda = { 1 };  % note the use of braces
pde.mf_u = mf;       % this does not copy whole objects, just their handles
pde.mf_d = mf;
expr_u = 'y.*(y-1).*x.*(x-1)+x.^5';
expr_f = '-(2*(x.^2+y.^2)-2*x-2*y+20*x.^3)';
pde.F = { expr_f };         % the volumic source
pde.bound{1}.type = 'Dirichlet';
pde.bound{1}.R = { expr_u };  % we force the value of the solution on the boundary
[U]=gf_solve(pde);
Uexact = gf_mesh_fem_get(mf,'eval', { expr_u }); % interpolate the exact solution
subplot(2,1,1); gf_plot(mf,U,'mesh','on','contour',.01:.01:.1); colorbar;title('computed solution');
subplot(2,1,2); gf_plot(mf,U-Uexact,'mesh','on'); colorbar;title('difference with exact solution');

disp(sprintf('H1 norm of error: %g', gf_compute(mf,U-Uexact,'H1 norm')));
