from getfem import *
from numarray import *
print 'importing..'
m=Mesh('import','gid','../tripod.GiD.msh')
print 'done!'
mfu=MeshFem(m,3)
mfd=MeshFem(m,1)
mfe=MeshFem(m,1)
degree = 1	
mfu.set_fem(Fem('FEM_PK(3,%d)' % (degree,)),Integ('IM_TETRAHEDRON(5)'))
mfe.set_fem(Fem('FEM_PK_DISCONTINUOUS(3,%d,0.01)' % (degree,)))
mfd.set_fem(Fem('FEM_PK(3,0)'))

print 'nbcvs=%d, nbpts=%d, qdim=%d, fem = %s, nbdof=%d' % \
      (m.nbcvs(), m.nbpts(), mfu.qdim(), mfu.fem()[0].char(), mfu.nbdof())
P=m.pts()
pidtop=compress(abs(P[1,:] - 13) < 1e-6, range(0, m.nbpts()))
pidbot=compress(abs(P[1,:] + 10) < 1e-6, range(0, m.nbpts()))
ftop=m.faces_from_pid(pidtop)
fbot=m.faces_from_pid(pidbot)
NEUMANN_BOUNDARY = 1
DIRICHLET_BOUNDARY = 2

for mf in [mfu,mfd]:
    mf.set_boundary(NEUMANN_BOUNDARY,ftop)
    mf.set_boundary(DIRICHLET_BOUNDARY,fbot)

E=1e3
Nu=0.3
Lambda = E*Nu/((1+Nu)*(1-2*Nu))
Mu =E/(2*(1+Nu))

F = asm_boundary_source(NEUMANN_BOUNDARY, mfu,mfd,repeat([[0],[-1],[0]], mfd.nbdof(),1))
K = asm_linear_elasticity(mfu, mfd, repeat([Lambda], mfd.nbdof()), repeat([Mu], mfd.nbdof()));

# handle Dirichlet condition
(H,R)=asm_dirichlet(DIRICHLET_BOUNDARY, mfu, mfd, mfd.eval('numarray.identity(3)'), mfd.eval('[0,0,0]'));
(N,U0)=asm_dirichlet_nullspace(H,R)
Nt=Spmat('copy',N); Nt.transpose()
KK=Nt*K*N
FF=Nt*F

# solve ...
print "preconditioner.."
P=Precond('ildlt',KK)
print "solving..."
UU=linsolve_cg(KK,FF,P)
print "done!"
U=N*UU+U0

# post-processing
sl=Slice(('none',), mf, degree)

# compute the Von Mises Stress
DU=compute_gradient(mfu,U,mfe)
VM=zeros((DU.shape[2],),'d')
Sigma=DU

for i in range(0, DU.shape[2]):
  d = array(DU[:,:,i]);
  E = (d+transpose(d))*0.5
  Sigma[:,:,i]=E
  VM[i] = sum(E.flat**2) - (1./3.)*sum(diagonal(E))**2
  if VM[i] > 0.1:
	print i, VM[i]

print VM.min(), VM.max()

# export results to VTK (you can use http://mayavi.sourceforge.net/ to view these results )
# i.e. with  "mayavi -d tripod.vtk -m BandedSurfaceMap -f WarpVector"
sl.export_to_vtk('tripod.vtk', 'ascii',mfe,  [VM],'Von Mises Stress', mfu, [U], 'Displacement')
sl.export_to_vtk('tripod_edges.vtk','edges')

# export to OpenDX
sl.export_to_dx('tripod.dx', 'ascii', mfe, [VM],'Von Mises Stress')

# export the displacement and the stress tensor field
SigmaSL = compute_interpolate_on(mfe,Sigma,sl);
sl.export_to_vtk('tripod_ev.vtk', mfu, U, 'displacement', SigmaSL, 'stress')

