# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for EskimoTube.com videos.
"""


import re

from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("EskimoTube",)


class EskimoTube(HTMLPlugin):

    """Plugin for EskimoTube.com videos."""

    match_re = re.compile(r"^http://eskimotube\.com/(?P<mediumid>.+)\.html")
    url_format = "http://eskimotube.com/%s.html"
    website_name = "EskimoTube.com"

    def get_file_url(self, high_quality=False):
        """Return video file URL."""
        for element in self.page.getiterator("a"):
            if element.get("href").endswith(".mp4"):
                return element.get("href")
