# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for ExtremeTube.com videos.
"""


from getmediumurl.htmlplugin import HTMLPlugin


__all__ = ("ExtremeTube",)


class ExtremeTube(HTMLPlugin):

    """Plugin for ExtremeTube.com videos."""

    url_format = "http://www.extremetube.com/video/%s"
    website_name = "ExtremeTube.com"

    @property
    def title(self):
        """Video title."""
        return self.get_content_substring("flashvars.video_title = '",
                                          "';").replace("+", " ")

    def get_file_url(self, high_quality=False):
        """Return video file URL."""
        return self.get_content_substring("flashvars.video_url = '",
                                          "';")
