# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Test some of `getmediumurl.format` and related `getmediumurl.plugin`
code.
"""


import unittest

from getmediumurl.plugin import Plugin


__all__ = ("FormatTestCase",)


class NoFormatPlugin(Plugin):

    """A plugin for media without formats."""

    def formats(self):
        """Return an iterable of no formats."""
        return ()


class FormatTestCase(unittest.TestCase):

    """Test format-related interfaces."""

    def test_no_formats(self):
        """Test that plugin with no formats has no file URL"""
        plugin = NoFormatPlugin(u"", None)
        self.assert_(plugin.get_file_url(high_quality=False) is None)
        self.assert_(plugin.get_file_url(high_quality=True) is None)
