# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Test methods of Plugin objects.
"""


import unittest

from getmediumurl import Matcher

from tests_getmediumurl.shared import requirehtml


__all__ = ("GettingPluginTestCase",)


class GettingPluginTestCase(unittest.TestCase):

    """Test getting plugin and mediumid."""

    def setUp(self):
        """Prepare Matcher and plugin."""
        self.matcher = Matcher()
        self.url = "http://www.youtube.com/watch?v=xxxxxxxxxxx"
        self.plugin = self.matcher.match(self.url)

    @requirehtml
    def test_is_usable(self):
        """Test that usable plugins are usable"""
        self.assertTrue(not list(self.plugin.disabled()))

    @requirehtml
    def test_url(self):
        """Test that url returns the original URL"""
        self.assertEqual(self.url, self.plugin.url)

    @requirehtml
    def test_plugin_name(self):
        """Test plugin name"""
        self.assertEqual(self.plugin.get_plugin_name(), "YouTube")

    @requirehtml
    def test_website_name(self):
        """Test website name"""
        self.assertEqual(self.plugin.website, "YouTube")

    @requirehtml
    def test_get_plugin(self):
        """Test that the same plugin can be found"""
        another = self.matcher.get_plugin("YouTube",
                                          self.plugin.mediumid)
        self.assertEqual(self.plugin.mediumid, another.mediumid)
        self.assert_(self.plugin.__class__ is another.__class__)
