#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Script used to install GetMediumURL.
"""


from setuptools import setup, find_packages


VERSION = "0.0"
RELEASE = "0.0a2"


setup(
    name="GetMediumURL",
    version=RELEASE,
    author="Michał Masłowski",
    author_email="mtjm@mtjm.eu",
    url="http://savannah.nongnu.org/projects/getmediumurl/",
    download_url="http://download.savannah.gnu.org/releases/getmediumurl/",
    packages=find_packages(),
    description="A package for getting URLs of media files from some websites",
    long_description=open("README.txt").read(),
    license="GNU Affero General Public License v3 or later",
    classifiers=(
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU Affero General Public License v3",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Topic :: Software Development :: Libraries :: Python Modules",
        ),
    test_suite="tests_getmediumurl.__init__",
    use_2to3=True,
    package_data = {
        "tests_getmediumurl.htdocs": ["*.html", "*.xml"],
        },
    zip_safe=True,
    command_options={
        "build_sphinx": {
            "version": ("setup.py", VERSION),
            "release": ("setup.py", RELEASE),
            },
        },
    install_requires=(
        "lxml",
        ),
    )
