# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Current plugin for GetMediumURL."""


from urlreader.propcache import cachedproperty

from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import SimpleFormat
from getmediumurl.utils import parse_urlpart


__all__ = ("Current",)


class CurrentMedium(HTMLMedium):

    """Current video."""

    url_format = "http://current.com/%s"

    @cachedproperty
    def _video_src(self):
        """The ``href`` of ``<link rel="video_src" ...>``."""
        href = self.page.xpath("/html/head/link[@rel='video_src']/@href")[0]
        return parse_urlpart(href, "fragment")

    def __iter__(self):
        """Iterate formats."""
        yield SimpleFormat(url=self._video_src["assetUrl"][0])

    @property
    def title(self):
        """Video title."""
        return self._video_src["contentTitle"][0].replace("+", " ")


class Current(HTMLPlugin):

    """Plugin for Current."""

    url_format = "http://current.com/%s"
    medium_class = CurrentMedium
