# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for CaracolTV.com videos.
"""


from urlreader.propcache import cachedproperty

from getmediumurl.compat import parse_qs
from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format


__all__ = ("CaracolTV",)


class CaracolTVMedium(HTMLMedium):

    """Video on CaracolTV.com"""

    url_format = "http://caracoltv.com/%s"
    website_name = "CaracolTV.com"

    @cachedproperty
    def _flash_vars(self):
        """Variables used by the Flash player."""
        return parse_qs(self.page.xpath("//param[@name='FlashVars']"
                                        "/@value")[0])

    def __iter__(self):
        """Iterate video formats."""
        yield Format(url=self._flash_vars["file"][0])

    @property
    def thumbnail(self):
        """Video thumbnail URL."""
        return self._flash_vars["image"][0]


class CaracolTV(HTMLPlugin):

    """Plugin for CaracolTV.com videos."""

    url_format = "http://caracoltv.com/%s"
    medium_class = CaracolTVMedium
