# -*- coding: utf-8 -*-
# Copyright (C) 2011  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""A plugin for pages containing possible links to FLV files."""


from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format


__all__ = ("GenericFLV",)


class GenericFLVMedium(HTMLMedium):

    """A medium using a FLV file."""

    url_format = "http://%s"

    def __iter__(self):
        """Iterate formats."""
        yield Format(url=self.get_content_substring(start="file=",
                                                          end=".flv"),
                           mime_type="video/x-flv")


class GenericFLV(HTMLPlugin):

    """Plugin for videos in FLV files."""

    url_format = "http://%s"
    medium_class = GenericFLVMedium

    @classmethod
    def match(cls, url, matcher):
        """Match an URL to the plugin."""
        plugin = super(GenericFLV, cls).match(url, matcher)
        if plugin is None:
            return
        for medium in plugin:
            if medium.get_content_substring(start="file=",
                                            end=".flv") is not None:
                return plugin
