# -*- coding: utf-8 -*-
# Copyright (C) 2011  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Test parsing HTTP Content-Type headers."""


import unittest


__all__ = ("ContentTypeTestCase",)


class ContentTypeTestCase(unittest.TestCase):

    """Test parsing HTTP Content-Type headers."""

    def test_content_type(self):
        """Test parsing HTTP Content-Type headers"""
        from getmediumurl.utils import parse_content_type
        for header, value in (
            ("image/gif", ("image/gif", {})),
            ("text/html; charset=ISO-8859-4",
             ("text/html", {"charset": "ISO-8859-4"})),
            ("text/plain; charset=ascii; codecs=webm",
             ("text/plain", {"charset": "ascii", "codecs": "webm"})),
            ("text/plain; charset=\"UTF-8\\\"\"",
             ("text/plain", {"charset": "UTF-8\""})),
            ):
            self.assertEquals(parse_content_type(header), value)

    def test_invalid_content_type(self):
        """Test parsing invalid HTTP Content-Type headers"""
        from getmediumurl.utils import parse_content_type
        for header in (
            "image/",
            "/html",
            "imagine",
            "text=plain/html",
            "text/plain; charset=:-(",
            "text/plain; .",
            "text/plain;",
            "text/plain; charset=\"UTF-8",
            "text/plain; charset=\"UTF-8\\\"",
            ):
            self.assertEquals(parse_content_type(header), ("", {}))
