<?

/**
* This API can be used to connect to a DIG Server. Also you can use it to build 
* a request and send it to the server.
*
* If you find this software useful or if you found some bugs write a mail
* to "bacher (at) bash (minus) it (dot) de"
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* $Header: /sources/gfo/BODIGger/lib/DIGger.php,v 1.13 2007/01/12 15:04:05 punkrock Exp $
*
* @copyright 2006 joshua bacher
* @author joshua bacher
* @package DIGger
*/
						    
require("Request.php");
require("Expression.php");
include("lib/Color.php");


/**
* class should provide handling of a pellet server. it is not written so far.
* @package DIGger
*/ 
class Reasoner
{
	public $Reasoner;
}

/**
* DIGger class as a interface to the dig reasoner.
* @package DIGger
*/
class DIGger 
{
	/**
       	* @var string contains the Identifier that is needed by the reasoner	
	*/
	public $_URI; 
	/**
       	* @var string host to connect to
	*/
	public $_HOST;
	/**
       	* @var integer Port to connect on host
	*/
	public $_PORT;
	/**
       	* @var XML Namespase to be used
	*/
	public $_XML_NS;
	/**
       	* @var XML Namespace to used
	*/
	public $_XML_NS_XSI;
	/**
       	* @var XML Namespace
	*/
	public $_XML_XSI;
	/**
       	* @var XML Identify string
	*/
	public $_XML_Identifier;
	/**
       	* @var array answer from the server
	*/
	public $_XMLResponse;
	/**
       	* @var Parser the XML parser object
	*/
	public $_XMLParser;
	/**
       	* @var array Respnse values
	*/
	public $_XMLIndex;
	/**
       	* @var array Response Values
	*/
	public $_XMLValues;
	/**
       	* @var XML the header for the XML Request
	*/
	public $_XMLHeader;
	/**
       	* @var debug
	*/
	public $debug=false;
	/**
       	* @var ConfigFile to use
	*/
	public $ConfigFile='digger.ini';
	/**
       	* @var error message that we have got.
	*/
	public $msg="";
	/**
       	* @var internal error code.
	*/
	public $error;
	/**
       	* @var error for the value:
	*/
	public $response_val;

	
	/**
	* Constructor sets some Standard config parameters
	*/
	public function DIGger($debug=false){
		$this->debug=$debug;
		$this->_HOST="localhost";
		$this->_PORT=8081;
		$this->_XML_Identifier='<?xml version="1.0" encoding="UTF-8"?>';
	        $this->_XML_NS='xmlns="http://dl.kr.org/dig/2003/02/lang"';
		$this->_XML_NS_XSI='xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"';
		$this->_XML_XSI='xsi:schemaLocation="http://dl.kr.org/dig/2003/02/lang http://dl-web.man.ac.uk/dig/2003/02/dig.xsd"';
		$this->_XMLHeader=	 $this->_XML_NS."\n"
					.$this->_XML_NS_XSI."\n"
					.$this->_XML_XSI;
	}

	/**
	* does not what it sound so far. it just sets parameter for the server to connect
	*/
	public function connect($URI, $HOST="localhost", $PORT=8081){
		$this->_URI=$URI;
		$this->_HOST=$HOST;
		$this->_PORT=$PORT;
	}

	/**
	* Parameters from Config file Section [General] are set as Class variables. 
	*
	* A [var] from the config file is read and will translated to the class var [_var]
	*/
	public function readConfigFile($FileName){
		$this->ConfigFile=$FileName;
		$Config=parse_ini_file($FileName);
		foreach ($Config as $key => $val){
			$this->{"_$key"}=$val;
		}
	}

	/**
	* not realized so far
	*/
	public function setHeader(){
	}

	/**
	* outputs a string instead of true false.
	*/
	public function testConnection(){
		if (empty($this->_URI))
			$this->error("No URI given.");
		elseif ($this->identify()==true)
			return "access granted.";
		else return "access denied.";
	}
	/**
	* read DIG from $infile
	*/
	public function DIGIn($infile){
		if (!file_exists($infile)) throw new Exception("File '$infile' not found.");
		elseif (!is_readable($infile))  throw new Exception("Could not read from '$infile' .");
		else return file_get_contents($infile);
	}
	
	/**
	* Releasing a knowledgebase means to delete its content from the server. so use this function with care.
	*/
	public function releaseKB(){
		throw new Exception("Function not implemented yet.");
	}
	
	/**
	* not realized so far but should later realize a ask request for the DIG Server.
	*/
	public function ask($question){
		if (! $question instanceof Expression)
		       throw new Exception ("Not a Expression.\n");
	}
	
	/**
	* performs a tell request. either from file or from the String.
	*/
	public function tell($knowledge, $filemode=false){
		if ($filemode === TRUE){
			if (gettype($knowledge) != "array")
				$knowledge=array(0=>$knowledge);
			foreach($knowledge as $key=>$val){
				$request=$this->DIGIn($val);
				$request="<tells {$this->_XMLHeader} uri=\"{$this->_URI}\">\n".$request."</tells>";
				$this->sendRequest($request);
			}
		}
		elseif (! $knowledge instanceof Expression){
		       throw new Exception ("Not a DIGExpressionString.\n");
		}
		else  {
			$query="<tells {$this->_XMLHeader} uri=\"{$this->_URI}\">\n".$knowledge->toDIG()."</tells>";
		}
		if ($this->debug){
			//echo "\n";
			//print_r ($this->_XMLValues);
		}
		//print_r($this->_XMLIndex[1]);
		return true;
	}
	/**
	* sends a identify request to the DIG Server. can be later used to check if the server is online.
	*/
	public function identify(){
		$request=	'<getIdentifier '.($this->_XMLHeader).'	/>';
		$ret=$this->sendRequest($request, false);
		 return (($ret===false) ? false:true);
	}

	/**
	* set a new URI
	*/
	public function setURI($URI){
		$this->_URI=$URI;
	}

	/**
	* get the URI name
	* @return string URI
	*/
	public function getURI(){
		return $this->_URI;
	}

	/**
	* creates a new Knowledgebase and gives back the access URI 
	* @return string URI
	*/
	public function newKB(){
		$request="<newKB ". $this->_XMLHeader. "/>";
		$response= $this->sendRequest($request, false);
		$kbidx=$this->_XMLValues["KB"][0];
		$this->_URI=$this->_XMLIndex[$kbidx]["attributes"]["URI"];
		if (empty($this->_URI))
		       throw new Exception ("No new Knowledgebase released.\n".var_export($this->_XMLValues)
							."\nAre you sure that your reasoner is running "
							."and you have the right connection Parameters for it?");
		$this->SaveConfig();
	}

	/**
	* Send a Request to the DIG Server. 
	* @param string $msg request that should be sent to the server.
	* @return array Answer from the Server.
	*/
	public function sendRequest($msg, $checkURI=true){
		$req = new HTTP_Request($this->_HOST.":".$this->_PORT);
		$req->setMethod(HTTP_REQUEST_METHOD_POST);
		$req->addHeader("Accept-Encoding", "none");
		$req->setBody($this->_XML_Identifier.$msg);

		if (empty($this->_URI ) &&  $checkURI){
			$this->error=2001;
			$this->msg="No URI set.";
			$this->response_val=$this->msg;
		}
		//echo "\n\n$msg\n\n";
		if (!PEAR::isError($req->sendRequest(), $error)) {
			$response1 = $req->getResponseBody();
		} else {
			$response1 = $req->getResponseBody();
			$response2 = $req->getResponseCode();
			if (empty($response2))
				return false;	
			//throw new Exception("Connection to Server failed. Check if the the Server is running");
			else
				//throw new Exception("Connection to Server failed with code: ".$response1);
				return false;
		}
		$this->_XMLResponse=$response1;
		$this->ParseResponse();
		$this->CheckResponse();
		return $response1;
	}

	private function ParseResponse(){
		if (isset($this->_XMLParser))
			xml_parser_free($this->_XMLParser);
		$this->_XMLParser = xml_parser_create ();
		xml_parse_into_struct($this->_XMLParser, $this->_XMLResponse, $this->_XMLIndex, $this->_XMLValues);
	}

	public function CheckResponse(){
		$val=$this->_XMLIndex[1];
		foreach ($this->_XMLIndex as $key=>$val){
			if (eregi("ERROR", $val["tag"])){
				$this->msg=$val["attributes"]["MESSAGE"];
				$this->error=$val["attributes"]["CODE"];
				$this->response_val=$val["value"];
				return false;
			}
		}
		return true;
	}
	/**
	* check for errormessages
	* @return bool, true if error occured. else false
	*/
	public function isError(){
		if (empty($this->_URI)){
			$this->error=2001;
			$this->msg="No URI set.";
			$this->response_val=$this->msg;
		}
		return (!empty($this->error))?true:false;
	}

	/**
	* saves the config to a file.
	*/
	public function SaveConfig(){
		if (empty($this->ConfigFile)) throw new Exception("No Config File");
		$of=fopen($this->ConfigFile, "w");
		//fwrite($of, "[General]");
		fwrite($of, "\nURI=".$this->_URI);
		fwrite($of, "\nHOST=".$this->_HOST);
		fwrite($of, "\nPORT=".$this->_PORT);
		fclose($of);
		return true;
	}

	/**
	* Standard DIGger error message style.
	*/
	private function error($msg){
		echo "DIGger Error:" . $msg."\n";
	}

}
/**
* build a question for the DIG Server
* @package DIGger
*/
class DigAsk extends DIGger
{
	public $query;

	public function allConcepts(){
		$this->query.="<allConceptNames/>";
	}

	public function allRoles(){
		$this->query.="<allRoleNames/>";
	}
	
	public function allIndividuals(){
		$this->query.="<allIndividuals/>";
	}

	public function satisfiable($expression){
		if ( ! $expression instanceof DIGExpression ){
			throw new Exception("Not a DIGConcept!");
		}
		$this->query.="<satisfiable>".$expression->toDIG()."</satisfiable>";
	}
	public function submit(){
		//$this->query="<ask>\n".$this->query."\n</ask>";
		return $this->sendRequest("<asks {$this->_XMLHeader} uri=\"{$this->_URI}\">\n".$this->query."</asks>");
	}
}

class DIGTell extends DIGger
{
	
}

?>
