/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYEXTRAS_VIEW_COMPOSITE_HH_
#define _BAKERYEXTRAS_VIEW_COMPOSITE_HH_

#include "BakeryExtras/View.hh"
#include <vector>

namespace BakeryExtras {
  template< class T_Document >
  class View_Composite : public View<T_Document>
  {
  public: 
    View_Composite()
    {
    }
    
    virtual ~View_Composite()
    {
    }
    
    typedef View<T_Document> type_view;
    typedef std::vector<type_view*> type_vecViews;
    
    virtual void add_view(type_view* pView)
    {
      //Ensure that the view has the same document:
      //This should be unnecessary.
      if(pView)
	{
	  pView->set_document(get_document());
	  //Add it to the list of child views:
  	  m_vecViews.push_back(pView);
	}
    }
	
    virtual void remove_view(type_view* pView)
    {
      type_vecViews::iterator iter = std::find(m_vecViews.begin(), m_vecViews.end(), pView);
      if(iter != m_vecViews.end())
	m_vecViews.erase(iter);
    }
    
    virtual void set_document(T_Document* pDocument)
    {
      //Call base class:
      View<T_Document>::set_document(pDocument);
      
      //Change the document in the child views.
      for(type_vecViews::iterator iter = m_vecViews.begin(); iter != m_vecViews.end(); iter++)
	{
	  type_view* pView = *iter;
	  if(pView)
	    pView->set_document(pDocument);
	}
    }
    
    virtual void load_from_document()
    {
      //Delegate to the child views:
      for(type_vecViews::iterator iter = m_vecViews.begin(); iter != m_vecViews.end(); iter++)
	{
	  type_view* pView = *iter;
	  if(pView)
	    pView->load_from_document();
	}
    }
    
    virtual void save_to_document()
    {
      //Delegate to the child views:
      for(type_vecViews::iterator iter = m_vecViews.begin(); iter != m_vecViews.end(); iter++)
	{
	  type_view* pView = *iter;
	  if(pView)
	    pView->save_to_document();
	}
    }
    
  protected:
    type_vecViews m_vecViews;		
  };
}

#endif

