/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "BakeryGateway/Document.hh"
#include "BakeryGateway/View.hh"
#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"
#include "GEDCOMParser/ParseErrorManagement/ParseErrorManager.hh"
#include "GEDCOMParser/Serializer/Writer.hh"
#include "GEDCOMParser/Serializer/GEDCOMWriter.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/Visitor/GEDCOMSerializerVisitor.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"

BakeryGateway::Document::Document(void) : Bakery::Document(),
					  GEDCOMParser::LineageLinkageGedcom()
{
  return;
}
  
bool BakeryGateway::Document::load(void)
{
  bool res;
  GEDCOMParser::GEDCOMFactory * factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
  if (factory == 0)
    {
      GEDCOMParser::GEDCOMFactoryAccessor::Init();
      factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
    }
  clear();
  GEDCOMParser::Parser parser(factory, this);
  std::string filename = Bakery::Document::get_filepath();
  GEDCOMParser::ParseErrorManagement::ParseErrorManager parse_error_manager =  parser.Parse(filename, PARSERDEBUG);
  textdomain (PACKAGE);
  if (parse_error_manager.ErrorCount() > 0)
    {
      res = false;
    }
  else
    {
      set_modified(false);
      set_is_new(false);
      if(m_pView)
	{
	  dynamic_cast<BakeryGateway::View *>(m_pView)->getViewIndividualRecord()->InitCurrentIndividu();
	  m_pView->load_from_document();
	}
      res = true;
    }
  return res;
}

bool BakeryGateway::Document::save(void)
{
  std::string gedcom_content;
  bool res;
  GEDCOMParser::Writer * writer = new GEDCOMParser::GEDCOMWriter();
  GEDCOMParser::GEDCOMSerializerVisitor * visitor = new GEDCOMParser::GEDCOMSerializerVisitor();
  GEDCOMParser::LineageLinkageGedcom * lineage  = static_cast < GEDCOMParser::LineageLinkageGedcom * >(this);
  visitor->setWriter(writer);
  lineage->Accept(visitor);
  gedcom_content = writer->getBuffer();
  set_contents(gedcom_content);
  set_modified();
  delete writer; writer = 0;
  delete visitor; visitor = 0;
  res = Bakery::Document::save();
  return res;
}

void BakeryGateway::Document::set_filepath(const std::string& strVal, bool bEnforceFileExtension /* = false */)
{
  //  if(strVal != m_strFilePath)
  //    set_modified(); //Ready to save() for a Save As.

  m_strFilePath = strVal;

  //Enfore file extension:
  if(bEnforceFileExtension)
  {
    if(m_strFileExtension.size() != 0)  //If there is an extension to enforce.
    {
      bool bAddExt = false;
      std::string strExt = "." + get_file_extension();    
      
      if(m_strFilePath.size() < strExt.size()) //It can't have the ext already if it's not long enough.
      {
        bAddExt = true; //It isn't there already.
      }
      else
      {
        std::string strEnd = m_strFilePath.substr(m_strFilePath.size()-strExt.size());
        if(strEnd != strExt) //If it doesn't already have the extension
          bAddExt = true;
      }
 
      //Add extension if necessay.
      if(bAddExt)
        m_strFilePath += strExt;
        
      //Note that this does not replace existing extensions, so it could be e.g. 'something.blah.theext'
    }
  }
}

void BakeryGateway::Document::init(void)
{
  GEDCOMParser::GEDCOMFactory * factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
  if (factory == 0)
    {
      GEDCOMParser::GEDCOMFactoryAccessor::Init();
      factory = GEDCOMParser::GEDCOMFactoryAccessor::getFactory();
    }
  
  GEDCOMParser::Header * header = setHeader();
  header->setDefaults();
  header->setName(PACKAGE_NAME);
  header->setCorp("Copyright (c) 2002 by Cyril PICARD");
  GEDCOMParser::SubmitterRecord * submitter = addSubmitterRecord();
  header->setSubm(submitter->getId());
  submitter->setName("undefined submitter");
  GEDCOMParser::IndividualRecord * individual = addIndividualRecord();
  GEDCOMHelper::IndividualRecordHelper helper(individual, this);
  helper.setPersonalName("<first name>","<LAST NAME>");
  set_is_new(true);
  set_modified(false);
  return;
}

