/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#ifndef _BAKERY_GATEWAY_VIEWEVENT_HH_
#define _BAKERY_GATEWAY_VIEWEVENT_HH_

#include "config.h"
#include "bakery/bakery.h"
#include "BakeryExtras/View_Linked.hh"
#include "BakeryGateway/Document.hh"
#include "GEDCOMParser/EventDetailManager.hh"
#include "GEDCOMHelper/FamilyRecordHelper.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"
#include "GEDCOMHelper/EventDetailManagerHelper.hh"
#include "MMIEvent.hh"
#include <sigc++/object.h>

namespace BakeryGateway {
  template < class T_Record > 
  class ViewEvent : public BakeryExtras::View_Linked < BakeryGateway::Document, T_Record >,
		    public SigC::Object
  {
  public:
    ViewEvent(MMIEvent * mmi) :
      _mmi(mmi),
      _during_load(false),
      _during_save(false)
    {
      _mmi->date_changed().connect(SigC::slot(this, &ViewEvent::date_changed));
      _mmi->place_changed().connect(SigC::slot(this, &ViewEvent::place_changed));
      return;
    };
    virtual ~ViewEvent(void)
    {
      return;
    };

    virtual void load_from_document(void)
    {
      _during_load = true;
      if (IsLoadable())
	{
	  _mmi->Clear();
	  GEDCOMParser::EventDetailManager * const record_event = getRecordEvent();
	  if (record_event != 0)
	    {
	      GEDCOMHelper::EventDetailManagerHelper event_helper(record_event);
	      _mmi->setDate(event_helper.getDate());
	      _mmi->setPlace(event_helper.getPlace());
	    }
	  _mmi->show_all();
	}
      _during_load = false;
      return;
    };
  private:
    bool _during_load;
    bool _during_save;
    virtual GEDCOMParser::EventDetailManager * const getRecordEvent(void) = 0;
    virtual GEDCOMParser::EventDetailManager * const addRecordEvent(void) = 0;
    int date_changed(std::string new_date)
    {
      _during_save = true;
      _is_loadable = false;
      if (!_during_load)
	{
	  GEDCOMParser::EventDetailManager * record_event = getRecordEvent();
	  if (record_event == 0)
	    {
	      record_event = addRecordEvent();
	    }
	  GEDCOMHelper::EventDetailManagerHelper event_helper(record_event);
	  event_helper.setDate(new_date);
	  get_document()->set_modified(true);
	}
      _during_save = false;
      _is_loadable = true;
      return 0;
    };
    int place_changed(std::string new_place)
    {
      _during_save = true;
      _is_loadable = false;
      if (!_during_load)
	{
	  GEDCOMParser::EventDetailManager * record_event = getRecordEvent();
	  if (record_event == 0)
	    {
	      record_event = addRecordEvent();
	    }
	  GEDCOMHelper::EventDetailManagerHelper event_helper(record_event);
	  event_helper.setPlace(new_place);
	  get_document()->set_modified(true);
	}
      _during_save = false;
      _is_loadable = true;
      return 0;
    };
    MMIEvent * _mmi;
  };

  class ViewUnionEvent : public ViewEvent < GEDCOMParser::FamilyRecord >
  {
  public:
    ViewUnionEvent(MMIEvent * mmi) :
      ViewEvent < GEDCOMParser::FamilyRecord > (mmi)
    {
      return;
    };
  private:
    virtual GEDCOMParser::EventDetailManager * const getRecordEvent(void)
    {
      GEDCOMHelper::FamilyRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.getMarriageEvent();
      return res;
    };
    virtual GEDCOMParser::EventDetailManager * const addRecordEvent(void)
    {
      GEDCOMHelper::FamilyRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.setMarriage("","");
      return res;
    };
  };

  class ViewBirthEvent : public ViewEvent < GEDCOMParser::IndividualRecord >
  {
  public:
    ViewBirthEvent(MMIEvent * mmi) :
      ViewEvent < GEDCOMParser::IndividualRecord > (mmi)
    {
      return;
    };
  private:
    virtual GEDCOMParser::EventDetailManager * const getRecordEvent(void)
    {
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.getBirth();
      return res;
    };
    virtual GEDCOMParser::EventDetailManager * const addRecordEvent(void)
    {
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.setBirth("","");
      return res;
    };

  };

  class ViewDeathEvent : public ViewEvent < GEDCOMParser::IndividualRecord >
  {
  public:
    ViewDeathEvent(MMIEvent * mmi) :
      ViewEvent  < GEDCOMParser::IndividualRecord > (mmi)
    {
      return;
    };
  private:
    virtual GEDCOMParser::EventDetailManager * const getRecordEvent(void) 
    {
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.getDeath();
      return res;
    };
    virtual GEDCOMParser::EventDetailManager * const addRecordEvent(void)
    {
      GEDCOMHelper::IndividualRecordHelper helper(_parent_entity, get_document());
      GEDCOMParser::EventDetailManager * const res = helper.setDeath("","");
      return res;
    };


  };
};

#endif
