/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#ifndef _BAKERYGATEWAY_VIEWPERSONALNAME_HH_
#define _BAKERYGATEWAY_VIEWPERSONALNAME_HH_

#include "config.h"
#include "BakeryExtras/View_Linked.hh"
#include "BakeryExtras/View_Subscriber.hh"
#include "BakeryGateway/Document.hh"
#include "MMIPersonalName.hh"
#include "GEDCOMParser/IndividualRecord.hh"


namespace BakeryGateway {
  class ViewPersonalName : public BakeryExtras::View_Linked < BakeryGateway::Document, GEDCOMParser::IndividualRecord >,
			   public BakeryExtras::View_Subscriber < BakeryGateway::Document, GEDCOMParser::PersonalName >,
			   public  SigC::Object
  
  {
  public:
    ViewPersonalName(MMIPersonalName *);
    ~ViewPersonalName();
    virtual void load_from_document();
    virtual void save_to_document();
  private:
    bool _during_load;
    MMIPersonalName * _mmi_personal_name;
  };
};

#endif
