/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "WidgetIndividual.hh"

void WidgetIndividual::setValue(std::string const &label, std::string const &id)
{
  _label = label;
  _id = id;
  return;
}

std::string const &WidgetIndividual::getLabel(void) const
{
  return _label;
}

std::string const &WidgetIndividual::getId(void) const
{
  return _id;
}

WidgetIndividual::NavigationSignalHandler_t & WidgetIndividual::navigation_asked(void) 
{
  return _navigation_asked_signal;
}

WidgetIndividual::ChangeSignalHandler_t &WidgetIndividual::changed(void)
{
  return _changed_signal;
}

WidgetIndividual::UnlinkSignalHandler_t &WidgetIndividual::unlinked(void)
{
  return _unlinked_signal;
}

WidgetIndividual::NewSignalHandler_t &WidgetIndividual::newed(void)
{
  return _newed_signal;
}

void WidgetIndividual::setLinkMenuItemsFactory(MenuItemsFactory const * const factory)
{
  if ((_link_menu_items_factory != 0) && (_link_menu_items_factory != factory))
    {
      delete _link_menu_items_factory; _link_menu_items_factory = 0;
    }
  _link_menu_items_factory = factory;
  return;
}

void WidgetIndividual::setUnlinkMenuItemsFactory(MenuItemsFactory const * const factory)
{
  if ((_unlink_menu_items_factory != 0) && (_unlink_menu_items_factory != factory))
    {
      delete _unlink_menu_items_factory; _unlink_menu_items_factory = 0;
    }

  _unlink_menu_items_factory = factory;
  return;
}
