/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#ifndef _WIDGET_INDIVIDUAL_HH_
#define _WIDGET_INDIVIDUAL_HH_

#include <sigc++/slot.h>
#include <sigc++/object.h>
#include <sigc++/basic_signal.h>
#include "MenuItemsFactory.hh"
#include <gtk--/box.h>
#include <string>

class WidgetIndividual : public Gtk::VBox
{
public:
  WidgetIndividual(void) : 
    _label(),
    _id(),
    _navigation_asked_signal(),
    _changed_signal(),
    _link_menu_items_factory(0),
    _unlink_menu_items_factory(0)
  {};
  virtual ~WidgetIndividual(void)
  {
    delete _link_menu_items_factory; _link_menu_items_factory = 0;
    delete _unlink_menu_items_factory; _unlink_menu_items_factory = 0;
  };
    
  typedef int NavigationReturnHandler_t;
  typedef SigC::Signal2 < NavigationReturnHandler_t, std::string, bool > NavigationSignalHandler_t;
  typedef int ChangeReturnHandler_t;
  typedef SigC::Signal1 < ChangeReturnHandler_t, std::string > ChangeSignalHandler_t;
  typedef int UnlinkReturnHandler_t;
  typedef SigC::Signal0 < UnlinkReturnHandler_t > UnlinkSignalHandler_t;
  typedef int NewReturnHandler_t;
  typedef SigC::Signal0 < NewReturnHandler_t > NewSignalHandler_t;
  virtual void setValue(std::string const &label, std::string const &id);
  virtual std::string const & getLabel(void) const;
  virtual std::string const &getId(void) const;
  virtual NavigationSignalHandler_t & navigation_asked(void);
  virtual ChangeSignalHandler_t & changed(void);
  virtual UnlinkSignalHandler_t & unlinked(void);
  virtual NewSignalHandler_t & newed(void);
  void setLinkMenuItemsFactory(MenuItemsFactory const * const factory);
  void setUnlinkMenuItemsFactory(MenuItemsFactory const * const factory);
protected:
  std::string _label;
  std::string _id;
  NavigationSignalHandler_t  _navigation_asked_signal;
  ChangeSignalHandler_t _changed_signal;
  UnlinkSignalHandler_t _unlinked_signal;
  NewSignalHandler_t _newed_signal;
  MenuItemsFactory const * _link_menu_items_factory;
  MenuItemsFactory const * _unlink_menu_items_factory;
};

#endif
