/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMViewer tool 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMViewer tool is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMViewer tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMViewer tool ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/
#include "windowindividualbutton.hh"
#include "WidgetIndividual.hh"
#include "ButtonIndividual.hh"
#include "LabelIndividual.hh"
#include <gtk--/main.h>
#include "ConcreteMenuItemsFactory.hh"
#include <gtk--/box.h>

#include <iostream>

windowindividualbutton::windowindividualbutton(
) : Gtk::Window(GTK_WINDOW_TOPLEVEL)
{  
   Gtk::Window *window1 = this;
   Gtk::Box *box = manage(new Gtk::VBox());
   window1->add(*box);
   
   class WidgetIndividual * ButtonIndividual = manage(new class ButtonIndividual());
   ButtonIndividual->setValue("Cyril PICARD","1");
   MenuItemsFactory * factory = new ConcreteMenuItemsFactory();
   ButtonIndividual->setLinkMenuItemsFactory(factory);
   ButtonIndividual->navigation_asked().connect(slot(this, &windowindividualbutton::Navigate));
   ButtonIndividual->changed().connect(slot(this, &windowindividualbutton::Change));
   ButtonIndividual->unlinked().connect(slot(this, &windowindividualbutton::Unlink));
   ButtonIndividual->newed().connect(slot(this, &windowindividualbutton::New));
   class WidgetIndividual * LabelIndividual = manage(new class LabelIndividual());
   LabelIndividual->setValue("static individual","-1");
   window1->set_title("ButtonIndividual test window");
   box->pack_start(*ButtonIndividual);
   box->pack_end(*LabelIndividual);
   window1->show_all();
   this->destroy.connect( Gtk::Main::quit.slot() );
}

WidgetIndividual::NavigationReturnHandler_t windowindividualbutton::Navigate(std::string target, bool ctrl_selected)
{
  if (ctrl_selected)
    {
      std::cerr << "Navigation asked avec ctrl enfonc !" << std::endl;
    }
  else
    {
      std::cerr << "Navigation asked avec ctrl lach !" << std::endl;
    }
  return 0;
}

WidgetIndividual::ChangeReturnHandler_t windowindividualbutton::Change(std::string new_id)
{
  std::cerr << "Changed to " << new_id << std::endl;
}

WidgetIndividual::UnlinkReturnHandler_t windowindividualbutton::Unlink(void)
{
  std::cerr << "Unlinked !" << std::endl;
}

WidgetIndividual::NewReturnHandler_t windowindividualbutton::New(void)
{
  std::cerr << "Newed !" << std::endl;
}

windowindividualbutton::~windowindividualbutton()
{  
}
