/* 
   Copyright 2002 Cyril Picard

   This file is part of the GEDCOMParser library 
   (developed within the Genealogy Free Software Tools project).

   The GEDCOMParser library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   The GEDCOMParser library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GEDCOMParser library ; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMHelper/FamilyRecordHelper.hh"

void
GEDCOMHelper::FamilyRecordHelper::setSpouse (GEDCOMParser::
					     IndividualRecord const
					     &individual_record)
{
  if (individual_record.getSex () == GEDCOMParser::IndividualRecord::MALE)
    {
      _family_record->setHusb (individual_record.getId ());
    }
  else
    {
      _family_record->setWife (individual_record.getId ());
    }
  return;
}

void
GEDCOMHelper::FamilyRecordHelper::setSpouse (SmartPtr <
					     GEDCOMParser::IndividualRecord >
					     const &individual_record)
{
  if (!individual_record.Null ())
    {
      setSpouse (*(individual_record.getPtr ()));
    }
  return;
}

std::string GEDCOMHelper::FamilyRecordHelper::getSpouseId (GEDCOMParser::
							   IndividualRecord
							   const
							   &individual_record)
  const
{
  std::string res = _family_record->getHusb ();
  if (individual_record.getSex () == GEDCOMParser::IndividualRecord::MALE)
    {
      res = _family_record->getWife ();
    }
  return res;
}

void
GEDCOMHelper::FamilyRecordHelper::RemoveSpouse (GEDCOMParser::
						IndividualRecord const
						&individual_record)
{
  if (individual_record.getSex () == GEDCOMParser::IndividualRecord::MALE)
    {
      if (_family_record->getHusb () == individual_record.getId ())
	{
	  _family_record->setHusb ("");
	}
    }
  else
    {
      if (_family_record->getWife () == individual_record.getId ())
	{
	  _family_record->setWife ("");
	}
    }
  return;
}

GEDCOMParser::FamilyEvent * const
GEDCOMHelper::FamilyRecordHelper::getEvent (GEDCOMParser::FamilyEvent::
					    enumFamilyEvents const
					    &event_type) const
{
  GEDCOMParser::FamilyEvent * res = 0;
  GEDCOMParser::FamilyEvents_t const &
    events =
    _family_record->
    getFamilyEvents ();
  GEDCOMParser::FamilyEvents_t::const_iterator event_iter =
    find (events.begin (), events.end (), event_type);
  if (event_iter != events.end ())
    {
      res = (*event_iter).getPtr ();
    }
  return res;
}

GEDCOMParser::FamilyEvent *
  GEDCOMHelper::FamilyRecordHelper::getMarriageEvent (void) const
{

  GEDCOMParser::FamilyEvent * res = 0;
  res = getEvent (GEDCOMParser::FamilyEvent::e_Marr);
  return res;
}

GEDCOMParser::FamilyEvent *
  GEDCOMHelper::FamilyRecordHelper::setEvent (GEDCOMParser::FamilyEvent::
					      enumFamilyEvents const
					      &event_type,
					      std::string const &date,
					      std::string const &location)
{
  GEDCOMParser::FamilyEvent * event = getEvent (event_type);
  if (event == 0)
    {
      event = _family_record->addFamilyEvent ();
      event->setType (event_type);
    }
  SmartPtr < GEDCOMParser::Event > event_detail = event->getEvent ();
  if (event_detail.Null ())
    {
      event->setEvent ();
      event_detail = event->getEvent ();
    }
  event_detail->setDate (date);
  SmartPtr < GEDCOMParser::Place > place = event_detail->getPlace ();
  if (place.Null ())
    {
      event_detail->setPlace ();
      place = event_detail->getPlace ();
    }
  place->setPlaceValue (location);
  return event;
}


GEDCOMParser::FamilyEvent *
  GEDCOMHelper::FamilyRecordHelper::setMarriage (std::string const &date,
						 std::string const &location)
{
  GEDCOMParser::FamilyEvent::enumFamilyEvents const
    event_type =
    GEDCOMParser::FamilyEvent::e_Marr;
  GEDCOMParser::FamilyEvent * event = setEvent (event_type, date, location);
  return event;

}
