/* 
   Copyright 2002 Cyril Picard

   This file is part of the GEDCOMParser library 
   (developed within the Genealogy Free Software Tools project).

   The GEDCOMParser library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   The GEDCOMParser library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GEDCOMParser library ; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMHELPER_INDIVIDUAL_RECORD_HELPER_HH_
#define _GEDCOMHELPER_INDIVIDUAL_RECORD_HELPER_HH_


#include "GEDCOMParser/ChildToFamilyLink.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include "GEDCOMParser/IndividualAttribute.hh"
#include "GEDCOMParser/IndividualEvent.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/PersonalName.hh"
#include "GEDCOMParser/SpouseToFamilyLink.hh"

///
namespace GEDCOMHelper
{
  class IndividualRecordHelper
  {
  public:
    ///
    IndividualRecordHelper (GEDCOMParser::IndividualRecord *
			    const individual_record,
			    GEDCOMParser::
			    LineageLinkageGedcom &
			    lineage):_individual_record (individual_record),
      _lineage (&lineage)
    {
    };

      ///
      IndividualRecordHelper (GEDCOMParser::IndividualRecord *
			      const individual_record,
			      GEDCOMParser::LineageLinkageGedcom *
			      const
			      lineage):_individual_record (individual_record),
      _lineage (lineage)
    {
    };

  ///
  IndividualRecordHelper (SmartPtr < GEDCOMParser::IndividualRecord > &individual_record, GEDCOMParser::LineageLinkageGedcom & lineage):
    _individual_record (individual_record.getPtr ()), _lineage (&lineage)
    {
    };
    //@{        
    GEDCOMParser::IndividualRecord * const IndividualRecord (void) const
    {
      return _individual_record;
    };
    /// Set the first personal name
    GEDCOMParser::PersonalName *
      setPersonalName (std::string const &first_name,
		       std::string const &last_name);
    /// Set an event
    GEDCOMParser::IndividualEvent *
      setEvent (GEDCOMParser::IndividualEvent::
		enumIndividualEvents const &event_type,
		std::string const &date, std::string const &location);
    /// Set the birth
    GEDCOMParser::IndividualEvent * setBirth (std::string const &date,
					      std::string const &location);
    /// Set the death
    GEDCOMParser::IndividualEvent * setDeath (std::string const &date,
					      std::string const &location);
    /// Get the occupation
    std::string getOccupation (void) const;
    /// Set the occupation
    GEDCOMParser::IndividualAttribute *
      setOccupation (std::string const &occupation);
    /// Set the current individu as husband or wife (according to its gender)
    /// in the family given as parameter. If no family is given, creates a new one
    /// Returns the family record modified or created
    GEDCOMParser::FamilyRecord *
      setSpouseInFamily (GEDCOMParser::FamilyRecord * const family = 0);
    /// Set the current individu as child
    /// in the family given as parameter. If no family is given, creates a new one
    /// Returns the family record modified or created
    GEDCOMParser::FamilyRecord *
      setChildInFamily (GEDCOMParser::FamilyRecord * const family = 0);
    /// Get an event
    GEDCOMParser::IndividualEvent *
      const getEvent (GEDCOMParser::IndividualEvent::
		      enumIndividualEvents const &event) const;
    /// Get the Birth event
    GEDCOMParser::IndividualEvent * const getBirth (void) const;
    /// Get the Death event
    GEDCOMParser::IndividualEvent * const getDeath (void) const;
    /// Get the family record in which the parameter is spouse
    GEDCOMParser::FamilyRecord * getFamilySpouse (void);
    /// Get the family record in which the parameter is child
    GEDCOMParser::FamilyRecord * getFamilyChild (void);
    /// Get the parent of the current individu (father or mother according to the sex parameter)
    GEDCOMParser::IndividualRecord *
      getIndividualParent (std::string const &sex) const;
    /// Remove a child from a family
    void RemoveChildFromFamily (GEDCOMParser::FamilyRecord * const family);
    /// Remove a spouse from a family
    void RemoveSpouseFromFamily (GEDCOMParser::FamilyRecord * const family);
    //@}
  private:
    GEDCOMParser::IndividualRecord * const _individual_record;
    ///
    GEDCOMParser::LineageLinkageGedcom * const _lineage;
    ///
    GEDCOMParser::IndividualAttribute *
      const getOccupationObject (void) const;
    ///
    void RemoveNotUsedFamily (GEDCOMParser::FamilyRecord * const family);
  };
};

#endif
