/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "GEDCOMParser/Address.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

void
GEDCOMParser::Address::concAddr (std::string const &str)
{
  _addr = _addr + str;
  return;
}

void
GEDCOMParser::Address::contAddr (std::string const &str)
{
  _addr = _addr + "\n" + str;
  return;
}

void
GEDCOMParser::Address::setAdr1 (std::string const &str)
{
  _adr1 = str;
  return;
}

void
GEDCOMParser::Address::setAdr2 (std::string const &str)
{
  _adr2 = str;
  return;
}


void
GEDCOMParser::Address::setCity (std::string const &str)
{
  _city = str;
  return;
}

void
GEDCOMParser::Address::setState (std::string const &str)
{
  _state = str;
  return;
}

void
GEDCOMParser::Address::setPost (std::string const &str)
{
  _post = str;
  return;
}

void
GEDCOMParser::Address::setCountry (std::string const &str)
{
  _country = str;
  return;
}

void
GEDCOMParser::Address::setPhone (std::string const &str)
{
  _phone = _phone + str;
  return;
}

std::string const &
GEDCOMParser::Address::getAddr (void) const
{
  return _addr;
}

std::string const &
GEDCOMParser::Address::getAdr1 (void) const
{
  return _adr1;
}

std::string const &
GEDCOMParser::Address::getAdr2 (void) const
{
  return _adr2;
}

std::string const &
GEDCOMParser::Address::getCity (void) const
{
  return _city;
}

std::string const &
GEDCOMParser::Address::getState (void) const
{
  return _state;
}

std::string const &
GEDCOMParser::Address::getPost (void) const
{
  return _post;
}

std::string const &
GEDCOMParser::Address::getCountry (void) const
{
  return _country;
}

std::string const &
GEDCOMParser::Address::getPhone (void) const
{
  return _phone;
}

void
GEDCOMParser::Address::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitAddress (this);
  return;
}
