/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMParser/ChangelogManager.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

GEDCOMParser::ChangeDate *
  GEDCOMParser::ChangelogManager::setChangeDate (GEDCOMParser::ChangeDate *
						 const data)
{
  GEDCOMParser::ChangeDate * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createChangeDate ();
    }
  _change_date.setNull ();
  _change_date = SmartPtr < ChangeDate > (tmp_data);
  return _change_date.getPtr ();
}

SmartPtr < GEDCOMParser::ChangeDate > const &
GEDCOMParser::ChangelogManager::getChangeDate (void) const
{
  return _change_date;
}

void
GEDCOMParser::ChangelogManager::removeChangeDate (void)
{
  _change_date.setNull ();
  return;
}
