/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_DATA_HH_
#define _GEDCOMPARSER_DATA_HH_

#include <string>
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  /** @memo Implements the GEDCOM 5.5 data structure 
      (used in the HEADER structure)
  */
  class GEDCOMVisitor;

  ///
  class Data:public GEDCOMElement
  {
  protected:
    ///
    std::string _data;
    ///
    GEDCOMParser::DateManagement::DateValue * _date;
    ///
    std::string _copr;
  public:
    ///
    Data (void):_data (), _date (0), _copr ()
    {
    };
      ///
      Data (Data const &d):_data (d._data), _date (0), _copr (d._copr)
    {
      if (d._date != 0)
	{
	  _date = new GEDCOMParser::DateManagement::DateValue (*d._date);
	}
      return;
    };
    ///
    virtual ~ Data (void)
    {
      delete _date;
      _date = 0;
    };
    ///@name Accessors (set) 
    //@{
    ///
    void setData (std::string const &);
    ///
    void setDate (std::string const &);
    ///
    void setCopr (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{
    /// 
    virtual std::string const &getData (void) const;
    ///
    virtual std::string const getDate (void) const;
    ///
    GEDCOMParser::DateManagement::
      DateValue const *const getDateObject (void) const;
    ///
    virtual std::string const &getCopr (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
