/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_DATEMANAGEMENT_DATE_HH_
#define _GEDCOMPARSER_DATEMANAGEMENT_DATE_HH_

#include <string>

/// Package GEDCOMParser
namespace GEDCOMParser
{
  /// Implements the dates management (essentially parsing) in GEDCOM files
  namespace DateManagement
  {
    /** @memo Implements the GEDCOM 5.5 DATE primitive element
	The GEDCOM 5.5 specifications are extensed to manage french years with roman notation. The specification is now : 
	DATE_FREN: = {Size=4:35}
	[ <YEAR_FREN> | <MONTH_FREN> <YEAR_FREN> | <DAY> <MONTH_FREN> <YEAR_FREN> | <YEAR> | <MONTH_FREN> <YEAR> | <DAY> <MONTH_FREN> <YEAR> ]
	YEAR_FREN: = 
	[ AN | an | <NULL> ] ROMAN_NUMBER_YEAR
	ROMAN_NUMBER_YEAR:= 
	[ I | II | III | IV | V | VI | VII | VIII | IX | X | XI | XII | XIII | XIV | i | ii | iii | iv | v | vi | vii | viii | ix | x | xi | xii | xiii | xiv]
	For more details about French Republican calendar check \URL[Genealogy in France: Republican Calendar]{http://www.francogene.com/search-fr/calrep.html}
    */
    class Date
    {
    public:
      /// @memo Implements the GEDCOM 5.5 CALENDARS enumeration (typedef'd to enumCalendars)
      enum _enumCalendars
      {
	///
	e_Gregorian,
	///
	e_Julian,
	///
	e_French,
	///
	e_Hebrew,
	///
	e_Future,
	///
	e_Unknown
      };
      ///
      typedef enum _enumCalendars enumCalendars;
      /// @memo Implements the GEDCOM 5.5 DATE PRECISIONS enumeration (typedef'd to enumPrecisionDateTypes)
      enum _enumPrecisionDateTypes
      {
	///
	e_PrecisionNull,
	///
	e_Exact,
	///
	e_About,
	///
	e_Calculated,
	///
	e_Estimated
      };
      ///
      typedef enum _enumPrecisionDateTypes enumPrecisionDateTypes;
      /// @memo Implements the months enumeration (typedef'd to enumMonths)
      enum _enumMonths
      {
	///
	e_MonthNull,
	///
	e_Jan,
	///
	e_Feb,
	///
	e_Mar,
	///
	e_Apr,
	///
	e_May,
	/// 
	e_Jun,
	///
	e_Jul,
	/// 
	e_Aug,
	///
	e_Sep,
	///
	e_Oct,
	///
	e_Nov,
	///
	e_Dec,
	///
	e_Hebr_Tsh,
	///
	e_Hebr_Csh,
	///
	e_Hebr_Ksl,
	///
	e_Hebr_Tvt,
	///
	e_Hebr_Shv,
	///
	e_Hebr_Adr,
	///
	e_Hebr_Ads,
	///
	e_Hebr_Nsn,
	///
	e_Hebr_Iyr,
	///
	e_Hebr_Svn,
	///
	e_Hebr_Tmz,
	///
	e_Hebr_Aav,
	///
	e_Hebr_Ell,
	///
	e_Fren_Vend,
	///
	e_Fren_Brum,
	///
	e_Fren_Frim,
	///
	e_Fren_Nivo,
	///
	e_Fren_Pluv,
	///
	e_Fren_Vent,
	///
	e_Fren_Germ,
	///
	e_Fren_Flor,
	///
	e_Fren_Prai,
	///
	e_Fren_Mess,
	///
	e_Fren_Ther,
	///
	e_Fren_Fruc,
	///
	e_Fren_Comp
      };
      ///
      typedef enum _enumMonths enumMonths;
      /// @memo Store the format of the French year : decimal digit number (1794) or roman (VII) (typedef'd to enumFrenchYearFormat)
      enum _enumFrenchYearFormat
      {
	///
	e_FrenchYearFormat_Null,
	///
	e_FrenchYearFormat_Decimal,
	///
	e_FrenchYearFormat_Roman
      };
      ///
      typedef enum _enumFrenchYearFormat enumFrenchYearFormat;
        Date (void):_calendar (e_Gregorian),
	_day (""),
	_month (e_MonthNull),
	_year (""),
	_precision (e_PrecisionNull),
	_french_year_format (e_FrenchYearFormat_Null), _before_christ (false)
      {
      };
        Date (Date const &d):_calendar (d._calendar),
	_day (d._day),
	_month (d._month),
	_year (d._year),
	_precision (d._precision),
	_french_year_format (d._french_year_format),
	_before_christ (d._before_christ)
      {
      };
      ///@name Accessors (set) 
      //@{
      /// 
      void setCalendar (enumCalendars cal);
      ///
      void setDay (std::string const &day);
      ///
      void setMonth (enumMonths month);
      ///
      void setYear (std::string const &year);
      ///
      void setPrecision (enumPrecisionDateTypes prec);
      ///
      void setFrenchYearFormat (enumFrenchYearFormat format);
      ///
      void setBeforeChrist (bool val);
      //@}

      ///@name Accessors (get)
      //@{ 
      ///
        std::string const getDisplayValue (void) const;
      //@}
    private:
        enumCalendars _calendar;
        std::string _day;
      enumMonths _month;
        std::string _year;
      enumPrecisionDateTypes _precision;
      enumFrenchYearFormat _french_year_format;
      bool _before_christ;
    };
  };
};

#endif
