/** 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

#include "GEDCOMParser/DateManagement/Period.hh"
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)

void
GEDCOMParser::DateManagement::Period::setDateFrom (GEDCOMParser::
						   DateManagement::
						   Date const &from)
{
  _date_from = new GEDCOMParser::DateManagement::Date (from);
  return;
}

void
GEDCOMParser::DateManagement::Period::setDateTo (GEDCOMParser::
						 DateManagement::
						 Date const &to)
{
  if ((_date_to != 0) && (_date_to != &to))
    {
      delete
	_date_to;
      _date_to = 0;
    }
  if (_date_to != &to)
    {
      _date_to = new GEDCOMParser::DateManagement::Date (to);
    }
  return;
}

std::string const
GEDCOMParser::DateManagement::Period::getDisplayValue (void) const
{
  std::string res;
  if (_date_from != 0)
    {
      res = _("From ") + _date_from->getDisplayValue ();
    }
  if (_date_to != 0)
    {
      if (res != "")
	{
	  res = res + _(" to ") + _date_to->getDisplayValue ();
	}
      else
	{
	  res = res + _("To ") + _date_to->getDisplayValue ();
	}
    }
  return res;
}
