/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_EVENT_HH_
#define _GEDCOMPARSER_EVENT_HH_

#include <string>

#include "GEDCOMParser/AddressManager.hh"
#include "GEDCOMParser/Place.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 EVENT_DETAIL structure 
  class Event:public GEDCOMElement,
    public AttachmentManager, public AddressManager
  {
  public:
    typedef enum
    {
      e_None,
      e_Type,
      e_Date,
      e_Place,
      e_Address,
      e_Age,
      e_Agnc,
      e_Caus,
      e_Attachment
    }
    enumAttributes;
      Event (void):_type (""),
      _date (0),
      _place (), _age (""), _agnc (""), _caus (""), _updated_attr (e_None)
    {
    };
      Event (Event const &e):_type (e._type),
      _date (0),
      _place (e._place),
      _age (e._age),
      _agnc (e._agnc), _caus (e._caus), _updated_attr (e._updated_attr)
    {
      if (e._date != 0)
	{
	  _date = new GEDCOMParser::DateManagement::DateValue (*e._date);
	}
      return;
    };
    void copyLastUpdatedAttr (Event const &);
    void resetLastUpdatedAttr (void);
    virtual ~ Event (void)
    {
      delete _date;
      _date = 0;
    };
    enumAttributes const getUpdatedAttr (void) const;

    ///@name Accessors (set) 
    //@{
    void setType (std::string const &);
    ///
    void setDate (std::string const &);
    ///
    GEDCOMParser::Place * setPlace (Place * const data = 0);
    ///
    void setAddress (Address * const data = 0);
    ///
    void setAge (std::string const &);
    ///
    void setAgnc (std::string const &);
    ///
    void setCaus (std::string const &);
    ///
    void addAttachment (GEDCOMParser::Attachment * const data);
    ///
    void addMultimediaLink (GEDCOMParser::Attachment * const data);
    ///
    void addNoteStructure (GEDCOMParser::Attachment * const data);
    ///
    void addSourceCitation (GEDCOMParser::Attachment * const data);
    ///
    //@}

    ///@name Accessors (get)
    //@{ 
    virtual std::string const &getType (void) const;
    ///    
    virtual std::string const getDate (void) const;
    ///
    GEDCOMParser::DateManagement::
      DateValue const *const getDateObject (void) const;
    ///
    SmartPtr < Place > const &getPlace (void) const;
    ///
    virtual std::string const &getAge (void) const;
    ///
    virtual std::string const &getAgnc (void) const;
    ///
    virtual std::string const &getCaus (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    std::string _type;
    GEDCOMParser::DateManagement::DateValue * _date;
    SmartPtr < Place > _place;
    std::string _age;
    std::string _agnc;
    std::string _caus;
    enumAttributes _updated_attr;
    void _setType (std::string const &);
    void _setDate (GEDCOMParser::DateManagement::DateValue const &);
    void _setPlace (SmartPtr < Place > const &);
    void _setAddress (Address * const data = 0);
    void _setAge (std::string const &);
    void _setAgnc (std::string const &);
    void _setCaus (std::string const &);
    void _addAttachment (SmartPtr < GEDCOMParser::Attachment > const &data);
  };
};
#endif
