/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "FamilyEvent.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)

void
GEDCOMParser::FamilyEvent::setType (enumFamilyEvents type)
{
  _type = type;
  return;
}

void
GEDCOMParser::FamilyEvent::setHusbAge (std::string const &value)
{
  _husb_age = value;
  return;
}

void
GEDCOMParser::FamilyEvent::setWifeAge (std::string const &value)
{
  _wife_age = value;
  return;
}



GEDCOMParser::FamilyEvent::enumFamilyEvents GEDCOMParser::FamilyEvent::
getRawType (void) const
{
  return _type;
}

std::string const 
GEDCOMParser::FamilyEvent::getType (void) const
{
  std::string res;
  switch (_type)
    {
    case e_None:
      res = (_("None"));
      break;
    case e_Anul:
      res = (_("Annulment"));
      break;
    case e_Cens:
      res = (_("Census"));
      break;
    case e_Div:
      res = (_("Divorce"));
      break;
    case e_Divf:
      res = (_("Divorce filed"));
      break;
    case e_Enga:
      res = (_("Engagement"));
      break;
    case e_Marr:
      res = (_("Marriage"));
      break;
    case e_Marb:
      res = (_("Marriage bann"));
      break;
    case e_Marc:
      res = (_("Marriage contract"));
      break;
    case e_Marl:
      res = (_("Marriage license"));
      break;
    case e_Mars:
      res = (_("Marriage settlement"));
      break;
    case e_Even:
      res = (_("Other event"));
      break;
    default:
      res = (_("Unmanaged event"));
      break;
    }
  return res;
  
}

std::string const &
GEDCOMParser::FamilyEvent::getHusbAge (void) const
{
  return _husb_age;
}

std::string const &
GEDCOMParser::FamilyEvent::getWifeAge (void) const
{
  return _wife_age;
}

void
GEDCOMParser::FamilyEvent::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitFamilyEvent (this);
  return;
}
