/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "GEDCOMParser/GEDCOMFactory.hh"


GEDCOMParser::Address * GEDCOMParser::GEDCOMFactory::createAddress (void) const
{
  return new GEDCOMParser::Address ();
}

GEDCOMParser::Association *
  GEDCOMParser::GEDCOMFactory::createAssociation (void) const
{
  return new GEDCOMParser::Association ();
}


GEDCOMParser::ChangeDate *
  GEDCOMParser::GEDCOMFactory::createChangeDate (void) const
{
  return new GEDCOMParser::ChangeDate ();
}


GEDCOMParser::ChildToFamilyLink *
  GEDCOMParser::GEDCOMFactory::createChildToFamilyLink (void) const
{
  return new GEDCOMParser::ChildToFamilyLink ();
}


GEDCOMParser::Data * GEDCOMParser::GEDCOMFactory::createData (void) const
{
  return new GEDCOMParser::Data ();
}


GEDCOMParser::Event * GEDCOMParser::GEDCOMFactory::createEvent (void) const
{
  return new GEDCOMParser::Event ();
}


GEDCOMParser::FamilyEvent *
  GEDCOMParser::GEDCOMFactory::createFamilyEvent (void) const
{
  return new GEDCOMParser::FamilyEvent ();
}


GEDCOMParser::FamilyRecord *
  GEDCOMParser::GEDCOMFactory::createFamilyRecord (std::string const &id =
						   "") const
{
  return new GEDCOMParser::FamilyRecord (id);
}


GEDCOMParser::Header * GEDCOMParser::GEDCOMFactory::createHeader (void) const
{
  return new GEDCOMParser::Header ();
}


GEDCOMParser::IndividualAttribute *
  GEDCOMParser::GEDCOMFactory::createIndividualAttribute (void) const
{
  return new GEDCOMParser::IndividualAttribute ();
}


GEDCOMParser::IndividualEvent *
  GEDCOMParser::GEDCOMFactory::createIndividualEvent (void) const
{
  return new GEDCOMParser::IndividualEvent ();
}


GEDCOMParser::IndividualRecord *
  GEDCOMParser::GEDCOMFactory::createIndividualRecord (std::string const &id =
						       "") const
{
  return new GEDCOMParser::IndividualRecord (id);
}


GEDCOMParser::LdsIndividualOrdinance *
  GEDCOMParser::GEDCOMFactory::createLdsIndividualOrdinance (void) const
{
  return new GEDCOMParser::LdsIndividualOrdinance ();
}


GEDCOMParser::LdsSpouseSealing *
  GEDCOMParser::GEDCOMFactory::createLdsSpouseSealing (void) const
{
  return new GEDCOMParser::LdsSpouseSealing ();
}


GEDCOMParser::MultimediaLink *
  GEDCOMParser::GEDCOMFactory::createMultimediaLink (void) const
{
  return new GEDCOMParser::MultimediaLink ();
}


GEDCOMParser::MultimediaRecord *
  GEDCOMParser::GEDCOMFactory::createMultimediaRecord (std::string const &id =
						       "") const
{
  return new GEDCOMParser::MultimediaRecord (id);
}


GEDCOMParser::NoteRecord *
  GEDCOMParser::GEDCOMFactory::createNoteRecord (std::string const &id =
						 "") const
{
  return new GEDCOMParser::NoteRecord (id);
}


GEDCOMParser::NoteStructure *
  GEDCOMParser::GEDCOMFactory::createNoteStructure (void) const
{
  return new GEDCOMParser::NoteStructure ();
}


GEDCOMParser::PersonalName *
  GEDCOMParser::GEDCOMFactory::createPersonalName (void) const
{
  return new GEDCOMParser::PersonalName ();
}


GEDCOMParser::Place * GEDCOMParser::GEDCOMFactory::createPlace (void) const
{
  return new GEDCOMParser::Place ();
}


GEDCOMParser::RepositoryRecord *
  GEDCOMParser::GEDCOMFactory::createRepositoryRecord (std::string const &id =
						       "") const
{
  return new GEDCOMParser::RepositoryRecord (id);
}


GEDCOMParser::SourceCitation *
  GEDCOMParser::GEDCOMFactory::createSourceCitation (void) const
{
  return new GEDCOMParser::SourceCitation ();
}


GEDCOMParser::SourceRecord *
  GEDCOMParser::GEDCOMFactory::createSourceRecord (std::string const &id =
						   "") const
{
  return new GEDCOMParser::SourceRecord (id);
}


GEDCOMParser::SourceRecord::Data *
  GEDCOMParser::GEDCOMFactory::createSourceRecord_Data (void) const
{
  return new GEDCOMParser::SourceRecord::Data ();
}


GEDCOMParser::SourceRecord::Data::Event *
  GEDCOMParser::GEDCOMFactory::createSourceRecord_Data_Event (void) const
{
  return new GEDCOMParser::SourceRecord::Data::Event ();
}


GEDCOMParser::SourceRepositoryCitation *
  GEDCOMParser::GEDCOMFactory::createSourceRepositoryCitation (void) const
{
  return new GEDCOMParser::SourceRepositoryCitation ();
}


GEDCOMParser::SourceRepositoryCitation::SourceCallNumber *
  GEDCOMParser::GEDCOMFactory::
createSourceRepositoryCitation_SourceCallNumber (void) const
{
  return new GEDCOMParser::SourceRepositoryCitation::SourceCallNumber ();
}


GEDCOMParser::SpouseToFamilyLink *
  GEDCOMParser::GEDCOMFactory::createSpouseToFamilyLink (void) const
{
  return new GEDCOMParser::SpouseToFamilyLink ();
}


GEDCOMParser::Submission *
  GEDCOMParser::GEDCOMFactory::createSubmission (void) const
{
  return new GEDCOMParser::Submission ();
}


GEDCOMParser::SubmitterRecord *
  GEDCOMParser::GEDCOMFactory::createSubmitterRecord (std::string const &id =
						      "") const
{
  return new GEDCOMParser::SubmitterRecord (id);
}


GEDCOMParser::UserReference *
  GEDCOMParser::GEDCOMFactory::createUserReference (void) const
{
  return new GEDCOMParser::UserReference ();
}
