/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "LdsIndividualOrdinance.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::LdsIndividualOrdinance::setType (GEDCOMParser::
					       LdsIndividualOrdinance::
					       enumLdsIndividualOrdinance
					       type)
{
  _type = type;
  return;
}

void
GEDCOMParser::LdsIndividualOrdinance::setStat (std::string const &val)
{
  _stat = val;
  return;
}

void
GEDCOMParser::LdsIndividualOrdinance::setDate (std::string const &val)
{
  if (_date != 0)
    {
      delete
	_date;
      _date = 0;
    }
  _date = new GEDCOMParser::DateManagement::DateValue (val);
  return;
}

void
GEDCOMParser::LdsIndividualOrdinance::setTempleCode (std::string const &val)
{
  _temple_code = val;
  return;
}

void
GEDCOMParser::LdsIndividualOrdinance::setPlace (std::string const &val)
{
  _place = val;
  return;
}

void
GEDCOMParser::LdsIndividualOrdinance::setFamcXref (std::string const &val)
{
  _famc_xref = val;
  return;
}

GEDCOMParser::LdsIndividualOrdinance::
  enumLdsIndividualOrdinance GEDCOMParser::LdsIndividualOrdinance::
getType (void) const
{
  return _type;
}

std::string const &
GEDCOMParser::LdsIndividualOrdinance::getStat (void) const
{
  return _stat;
}

std::string const
GEDCOMParser::LdsIndividualOrdinance::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::LdsIndividualOrdinance::getDateObject (void) const
{
  return _date;
}


std::string const &
GEDCOMParser::LdsIndividualOrdinance::getTempleCode (void) const
{
  return _temple_code;
}

std::string const &
GEDCOMParser::LdsIndividualOrdinance::getPlace (void) const
{
  return _place;
}

std::string const &
GEDCOMParser::LdsIndividualOrdinance::getFamcXref (void) const
{
  return _famc_xref;
}

void
GEDCOMParser::LdsIndividualOrdinance::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitLdsIndividualOrdinance (this);
  return;
}
