/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_LDS_INDIDIVIDUAL_ORDINANCE_HH_
#define _GEDCOMPARSER_LDS_INDIDIVIDUAL_ORDINANCE_HH_

#include <vector>
#include <string>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 LDS_INDIVIDUAL_ORDINANCE structure   
  class LdsIndividualOrdinance:public GEDCOMElement, public AttachmentManager
  {
  public:
    /// typedef'd to enumLdsIndividualOrdinance
    enum _enumLdsIndividualOrdinance
    {
      ///
      e_None,
      ///
      e_Bapl,
      ///
      e_Conl,
      ///
      e_Endl,
      ///
      e_Slgc
    };
    typedef enum _enumLdsIndividualOrdinance enumLdsIndividualOrdinance;
      LdsIndividualOrdinance (enumLdsIndividualOrdinance type =
			      e_None):_type (type), _stat (), _date (0),
      _temple_code (), _place (), _famc_xref ()
    {
    };
      LdsIndividualOrdinance (LdsIndividualOrdinance const &l):_type (l.
								      _type),
      _stat (l._stat), _date (0), _temple_code (l._temple_code),
      _place (l._place), _famc_xref (l._famc_xref)
    {
      if (l._date != 0)
	{
	  _date = new GEDCOMParser::DateManagement::DateValue (*l._date);
	}
      return;
    };

    virtual ~ LdsIndividualOrdinance (void)
    {
      delete _date;
      _date = 0;
    };
    ///@name Accessors (set) 
    //@{      
    void setType (enumLdsIndividualOrdinance);
    ///
    void setStat (std::string const &);
    ///
    void setDate (std::string const &);
    ///
    void setTempleCode (std::string const &);
    ///
    void setPlace (std::string const &);
    ///
    void setFamcXref (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{   
    ///
    enumLdsIndividualOrdinance getType (void) const;
    ///
    virtual std::string const &getStat (void) const;
    ///
    virtual std::string const getDate (void) const;
    ///
    GEDCOMParser::DateManagement::
      DateValue const *const getDateObject (void) const;
    ///
    virtual std::string const &getTempleCode (void) const;
    ///
    virtual std::string const &getPlace (void) const;
    ///
    virtual std::string const &getFamcXref (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    enumLdsIndividualOrdinance _type;
    std::string _stat;
    GEDCOMParser::DateManagement::DateValue * _date;
    std::string _temple_code;
    std::string _place;
    std::string _famc_xref;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many lds individual ordinances
  typedef std::vector < SmartPtr < LdsIndividualOrdinance >
    >LdsIndividualOrdinances_t;
  //@}

};
#endif
