/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_LINEAGE_GEDCOM_HH_
#define _GEDCOMPARSER_LINEAGE_GEDCOM_HH_

#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Header.hh"
#include "GEDCOMParser/Submission.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/MultimediaRecord.hh"
#include "GEDCOMParser/NoteRecord.hh"
#include "GEDCOMParser/RepositoryRecord.hh"
#include "GEDCOMParser/SourceRecord.hh"
#include "GEDCOMParser/SubmitterRecord.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"
#include "GEDCOMParser/IdGenerator.hh"

#include <algorithm>
#include <functional>
#include <iterator>

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 LINEAGE_LINKED_GEDCOM structure 
  class LineageLinkageGedcom:public GEDCOMElement
  {
  public:
    LineageLinkageGedcom (void):_header (),
      _submission (),
      _family_records (),
      _individual_records (),
      _multimedia_records (),
      _note_records (),
      _repository_records (),
      _source_records (), _submitter_records (), _id_generator (0)
    {
    };
     ~LineageLinkageGedcom (void);
    ///@name Accessors (set) 
    //@{        
    ///
      GEDCOMParser::Header * setHeader (Header * const data = 0);
    ///
      GEDCOMParser::Submission * setSubmission (Submission * const data = 0);
    ///
      GEDCOMParser::FamilyRecord * addFamilyRecord (FamilyRecord *
						    const data = 0);
    ///
    void RemoveFamilyRecord (SmartPtr < FamilyRecord > const &family);
    ///
    IndividualRecord *addIndividualRecord (IndividualRecord * const data = 0);
    ///
      GEDCOMParser::MultimediaRecord * addMultimediaRecord (MultimediaRecord *
							    const data = 0);
    ///
      GEDCOMParser::NoteRecord * addNoteRecord (NoteRecord * const data = 0);
    ///
      GEDCOMParser::RepositoryRecord * addRepositoryRecord (RepositoryRecord *
							    const data = 0);
    ///
      GEDCOMParser::SourceRecord * addSourceRecord (SourceRecord *
						    const data = 0);
    ///
      GEDCOMParser::SubmitterRecord * addSubmitterRecord (SubmitterRecord *
							  const data = 0);
    //@}

    ///@name Accessors (get)
    //@{        
      SmartPtr < Header > const &getHeader (void) const;
    ///
      SmartPtr < Submission > const &getSubmission (void) const;
    ///
    FamilyRecords_t const &getFamilyRecords (void) const;
    ///
    IndividualRecords_t const &getIndividualRecords (void) const;
    ///
    MultimediaRecords_t const &getMultimediaRecords (void) const;
    ///
    NoteRecords_t const &getNoteRecords (void) const;
    ///
    RepositoryRecords_t const &getRepositoryRecords (void) const;
    ///
    SourceRecords_t const &getSourceRecords (void) const;
    ///
    SubmitterRecords_t const &getSubmitterRecords (void) const;
    ///
    void clear (void);
    //@}
    void Accept (GEDCOMParser::GEDCOMVisitor *);
  private:
      SmartPtr < Header > _header;
      SmartPtr < Submission > _submission;
    FamilyRecords_t _family_records;
    IndividualRecords_t _individual_records;
    MultimediaRecords_t _multimedia_records;
    NoteRecords_t _note_records;
    RepositoryRecords_t _repository_records;
    SourceRecords_t _source_records;
    SubmitterRecords_t _submitter_records;
      GEDCOMParser::IdGenerator * _id_generator;
  };

};

#endif
